/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MaidConfigButton
extends Button {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_button.png");
    private final OnPress leftPress;
    private final OnPress rightPress;
    private boolean leftClicked = false;
    private Component value;

    public MaidConfigButton(int x, int y, Component title, Component value, OnPress onLeftPressIn, OnPress onRightPressIn) {
        super(Button.builder((Component)title, b -> {}).pos(x, y).size(164, 13));
        this.leftPress = onLeftPressIn;
        this.rightPress = onRightPressIn;
        this.value = value;
    }

    public MaidConfigButton(int x, int y, Component title, Component value, OnPress onPress) {
        this(x, y, title, value, onPress, onPress);
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        if (this.isHovered) {
            graphics.blit(ICON, this.getX(), this.getY(), 63.0f, 141.0f, this.width, this.height, 256, 256);
        } else {
            graphics.blit(ICON, this.getX(), this.getY(), 63.0f, 128.0f, this.width, this.height, 256, 256);
        }
        graphics.drawString(mc.font, this.getMessage(), this.getX() + 5, this.getY() + 3, 0x444444, false);
        this.drawCenteredStringWithoutShadow(graphics, mc.font, this.value, this.getX() + 142, this.getY() + 3, ChatFormatting.GREEN.getColor());
    }

    public void setValue(Component value) {
        this.value = value;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        boolean clickY;
        if (!this.active || !this.visible) {
            return false;
        }
        boolean leftClickX = (double)(this.getX() + 120) <= mouseX && mouseX <= (double)(this.getX() + 130);
        boolean rightClickX = (double)(this.getX() + 154) <= mouseX && mouseX <= (double)(this.getX() + 164);
        boolean bl = clickY = (double)this.getY() <= mouseY && mouseY <= (double)(this.getY() + this.getHeight());
        if (leftClickX && clickY) {
            this.leftClicked = true;
            return true;
        }
        if (rightClickX && clickY) {
            this.leftClicked = false;
            return true;
        }
        return false;
    }

    public void onPress() {
        if (this.leftClicked) {
            this.leftPress.onPress(this);
        } else {
            this.rightPress.onPress(this);
        }
    }

    public void drawCenteredStringWithoutShadow(GuiGraphics graphics, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.getVisualOrderText();
        graphics.drawString(pFont, formattedcharsequence, pX - pFont.width(formattedcharsequence) / 2, pY, pColor, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(MaidConfigButton var1);
    }
}

