/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BaubleButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.BaubleContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class BaubleContainerScreen
extends AbstractMaidContainerGui<BaubleContainer>
implements IBackpackContainerScreen {
    private static final ResourceLocation BAUBLE_BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_bauble.png");
    private final EntityMaid maid;
    private final int favorabilityLevel;

    public BaubleContainerScreen(BaubleContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.imageHeight = 256;
        this.imageWidth = 256;
        this.maid = ((BaubleContainer)this.menu).getMaid();
        this.favorabilityLevel = this.maid.getFavorabilityManager().getLevel();
    }

    @Override
    protected void initAdditionWidgets() {
        BaubleButton baubleButton = new BaubleButton(this.leftPos, this.topPos, true, btn -> {
            OpenMaidGuiPackage message = new OpenMaidGuiPackage(this.maid.getId(), 0);
            PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)baubleButton);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BAUBLE_BG);
        graphics.blit(BAUBLE_BG, this.leftPos + 85, this.topPos + 36, 0, 0, 165, 128);
        if (this.favorabilityLevel < 2) {
            graphics.fill(this.leftPos + 152, this.topPos + 81, this.leftPos + 240, this.topPos + 115, -1440603614);
            graphics.blit(BAUBLE_BG, this.leftPos + 190, this.topPos + 92, 165, 0, 11, 11);
        }
        if (this.favorabilityLevel < 3) {
            graphics.fill(this.leftPos + 152, this.topPos + 117, this.leftPos + 240, this.topPos + 151, -1440603614);
            graphics.blit(BAUBLE_BG, this.leftPos + 190, this.topPos + 127, 165, 0, 11, 11);
        }
    }

    @Override
    protected void renderAdditionTransTooltip(GuiGraphics graphics, int x, int y) {
        if (this.favorabilityLevel < 2 && this.leftPos + 152 <= x && x < this.leftPos + 240 && this.topPos + 81 <= y && y < this.topPos + 115) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.bauble_button.need_favorability_level", (Object[])new Object[]{2}), x, y);
        }
        if (this.favorabilityLevel < 3 && this.leftPos + 152 <= x && x < this.leftPos + 240 && this.topPos + 117 <= y && y < this.topPos + 151) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.bauble_button.need_favorability_level", (Object[])new Object[]{3}), x, y);
        }
    }
}

