/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTaskEnableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.MaidContainerGuiEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidSideTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.MaidSoundPackGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidSideTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ScheduleButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TaskButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouStateSwitchButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ipn.SortButtonScreen;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.OpenYsmMaidScreenEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMaidContainerGui<T extends AbstractMaidContainer>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_main.png");
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_side.png");
    private static final ResourceLocation BUTTON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_button.png");
    private static final ResourceLocation TASK = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_task.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final int TASK_COUNT_PER_PAGE = 12;
    private static int TASK_PAGE = 0;
    private static boolean TASK_LIST_OPEN = false;
    protected final EntityMaid maid;
    protected final IMaidTask task;
    protected final List<IMaidTask> notHiddenTasks;
    private final Map<String, AbstractWidget> eventAddButtons = Maps.newHashMap();
    private TouhouStateSwitchButton home;
    private TouhouStateSwitchButton pick;
    private TouhouStateSwitchButton ride;
    private TouhouImageButton info;
    private TouhouImageButton skin;
    @Nullable
    private TouhouImageButton ysmSkin;
    private TouhouImageButton sound;
    private TouhouImageButton pageDown;
    private TouhouImageButton pageUp;
    private TouhouImageButton pageClose;
    private TouhouImageButton taskSwitch;
    private MaidDownloadButton modelDownload;
    private ScheduleButton<T> scheduleButton;
    private int counterTime = 0;

    public AbstractMaidContainerGui(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageHeight = 256;
        this.imageWidth = 256;
        this.maid = ((AbstractMaidContainer)this.menu).getMaid();
        this.task = ((AbstractMaidContainer)this.menu).getMaid().getTask();
        this.notHiddenTasks = TaskManager.getNotHiddenTaskList(this.maid);
    }

    protected void clearWidgets() {
        super.clearWidgets();
        this.eventAddButtons.clear();
    }

    protected void init() {
        super.init();
        if (this.maid == null) {
            return;
        }
        this.clearWidgets();
        this.initBaseData();
        this.initAdditionData();
        this.initBaseWidgets();
        this.initAdditionWidgets();
        NeoForge.EVENT_BUS.post((Event)new MaidContainerGuiEvent.Init(this, this.leftPos, this.topPos, this.eventAddButtons));
        this.eventAddButtons.values().forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void initBaseData() {
    }

    protected void initAdditionData() {
    }

    protected void initBaseWidgets() {
        this.addHomeButton();
        this.addPickButton();
        this.addRideButton();
        this.addDownloadButton();
        this.addStateButton();
        this.addTaskSwitchButton();
        this.addTaskControlButton();
        this.addTaskListButton();
        this.addScheduleButton();
        this.addTabsButton();
        this.addSideTabsButton();
    }

    protected void initAdditionWidgets() {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.maid == null) {
            return;
        }
        this.drawModInfo(graphics);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawModInfo(graphics);
        this.drawEffectInfo(graphics);
        this.drawCurrentTaskText(graphics);
        this.renderAddition(graphics, mouseX, mouseY, partialTicks);
        NeoForge.EVENT_BUS.post((Event)new MaidContainerGuiEvent.Render(this, this.leftPos, this.topPos, this.eventAddButtons, graphics, mouseX, mouseY, partialTicks));
        this.renderTooltip(graphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new MaidContainerGuiEvent.Tooltip(this, this.leftPos, this.topPos, this.eventAddButtons, graphics, mouseX, mouseY, partialTicks));
    }

    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private void drawModInfo(GuiGraphics graphics) {
        String minecraftVersion = SharedConstants.getCurrentVersion().getName();
        String modVersion = ModList.get().getModFileById("touhou_little_maid").versionString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        graphics.drawCenteredString(this.font, debugInfo, this.leftPos + 40, this.topPos - 4, ChatFormatting.GRAY.getColor().intValue());
    }

    private void drawEffectInfo(GuiGraphics graphics) {
        if (TASK_LIST_OPEN) {
            return;
        }
        List<SendEffectPackage.EffectData> effects = this.maid.getEffects();
        if (!effects.isEmpty()) {
            int yOffset = 5;
            for (SendEffectPackage.EffectData effect : effects) {
                MutableComponent text = Component.translatable((String)effect.descriptionId());
                if (effect.amplifier() >= 1 && effect.amplifier() <= 9) {
                    MutableComponent levelText = Component.translatable((String)("enchantment.level." + (effect.amplifier() + 1)));
                    text = text.append(CommonComponents.SPACE).append((Component)levelText);
                }
                String duration = effect.duration() == -1 ? I18n.get((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtil.formatTickDuration((int)effect.duration(), (float)20.0f);
                text = text.append(CommonComponents.SPACE).append(duration);
                graphics.drawString(this.font, (Component)text, this.leftPos - this.font.width((FormattedText)text) - 3, this.topPos + yOffset + 5, this.getPotionColor(effect.category()));
                yOffset += 10;
            }
        }
    }

    private int getPotionColor(int category) {
        switch (category) {
            case 0: {
                return ChatFormatting.GREEN.getColor();
            }
            case 1: {
                return ChatFormatting.RED.getColor();
            }
        }
        return ChatFormatting.BLUE.getColor();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(BG, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        SortButtonScreen.renderBackground(graphics, this.leftPos + 249, this.topPos + 166);
        this.drawMaidCharacter(graphics, x, y);
        this.drawBaseInfoGui(graphics);
        this.drawTaskListBg(graphics);
        this.drawSideTabGui(graphics, partialTicks, x, y);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        graphics.pose().pushPose();
        super.renderTooltip(graphics, x, y);
        this.renderTransTooltip(this.home, graphics, x, y, "gui.touhou_little_maid.button.home");
        this.renderTransTooltip(this.pick, graphics, x, y, "gui.touhou_little_maid.button.pickup");
        this.renderTransTooltip(this.ride, graphics, x, y, "gui.touhou_little_maid.button.maid_riding_set");
        this.renderTransTooltip(this.modelDownload, graphics, x, y, "gui.touhou_little_maid.button.model_download");
        this.renderTransTooltip(this.skin, graphics, x, y, "gui.touhou_little_maid.button.skin");
        if (this.ysmSkin != null) {
            this.renderTransTooltip(this.ysmSkin, graphics, x, y, "gui.touhou_little_maid.button.ysm_skin");
        }
        this.renderTransTooltip(this.sound, graphics, x, y, "gui.touhou_little_maid.button.sound");
        this.renderTransTooltip(this.pageUp, graphics, x, y, "gui.touhou_little_maid.task.previous_page");
        this.renderTransTooltip(this.pageDown, graphics, x, y, "gui.touhou_little_maid.task.next_page");
        this.renderTransTooltip(this.pageClose, graphics, x, y, "gui.touhou_little_maid.task.close");
        this.renderTransTooltip(this.taskSwitch, graphics, x, y, "gui.touhou_little_maid.task.switch");
        this.renderAdditionTransTooltip(graphics, x, y);
        this.renderMaidInfo(graphics, x, y);
        this.renderScheduleInfo(graphics, x, y);
        this.renderTaskButtonInfo(graphics, x, y);
        this.modelDownload.renderExtraTips(graphics);
        graphics.pose().popPose();
    }

    protected void renderAdditionTransTooltip(GuiGraphics graphics, int x, int y) {
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        this.drawTaskPageCount(graphics);
    }

    private void addStateButton() {
        this.skin = new TouhouImageButton(this.leftPos + 62, this.topPos + 14, 9, 9, 72, 43, 10, BUTTON, b -> CacheIconManager.openMaidModelGui(this.maid));
        this.info = new TouhouImageButton(this.leftPos + 8, this.topPos + 14, 9, 9, 72, 65, 10, BUTTON, GuiTools.NO_ACTION);
        this.addRenderableWidget((GuiEventListener)this.skin);
        this.addRenderableWidget((GuiEventListener)this.info);
        if (YsmCompat.isInstalled()) {
            this.ysmSkin = new TouhouImageButton(this.leftPos + 52, this.topPos + 14, 9, 9, 144, 65, 10, BUTTON, b -> NeoForge.EVENT_BUS.post((Event)new OpenYsmMaidScreenEvent(this.maid)));
            this.sound = new TouhouImageButton(this.leftPos + 42, this.topPos + 14, 9, 9, 144, 43, 10, BUTTON, b -> this.getMinecraft().setScreen((Screen)new MaidSoundPackGui(this.maid)));
            this.addRenderableWidget((GuiEventListener)this.ysmSkin);
            this.addRenderableWidget((GuiEventListener)this.sound);
        } else {
            this.sound = new TouhouImageButton(this.leftPos + 52, this.topPos + 14, 9, 9, 144, 43, 10, BUTTON, b -> this.getMinecraft().setScreen((Screen)new MaidSoundPackGui(this.maid)));
            this.addRenderableWidget((GuiEventListener)this.sound);
        }
    }

    private void addTaskControlButton() {
        this.pageDown = new TouhouImageButton(this.leftPos - 72, this.topPos + 9, 16, 13, 93, 0, 14, TASK, b -> this.taskPageDown());
        this.pageUp = new TouhouImageButton(this.leftPos - 89, this.topPos + 9, 16, 13, 110, 0, 14, TASK, b -> this.taskPageUp());
        this.pageClose = new TouhouImageButton(this.leftPos - 19, this.topPos + 9, 13, 13, 127, 0, 14, TASK, b -> {
            TASK_LIST_OPEN = false;
            this.init();
        });
        this.addRenderableWidget((GuiEventListener)this.pageUp);
        this.addRenderableWidget((GuiEventListener)this.pageDown);
        this.addRenderableWidget((GuiEventListener)this.pageClose);
        this.pageUp.visible = TASK_LIST_OPEN;
        this.pageDown.visible = TASK_LIST_OPEN;
        this.pageClose.visible = TASK_LIST_OPEN;
    }

    private void taskPageUp() {
        if (TASK_PAGE > 0) {
            --TASK_PAGE;
            this.init();
        }
    }

    private void taskPageDown() {
        if (TASK_PAGE * 12 + 12 < this.notHiddenTasks.size()) {
            ++TASK_PAGE;
            this.init();
        }
    }

    private void addTaskListButton() {
        if (TASK_PAGE * 12 >= this.notHiddenTasks.size()) {
            TASK_PAGE = 0;
        }
        for (int count = 0; count < 12; ++count) {
            int index = TASK_PAGE * 12 + count;
            if (index >= this.notHiddenTasks.size()) continue;
            this.drawPerTaskButton(this.notHiddenTasks, count, index);
        }
    }

    private void drawPerTaskButton(List<IMaidTask> tasks, int count, int index) {
        IMaidTask maidTask = tasks.get(index);
        boolean[] enable = new boolean[]{true};
        ArrayList enableConditionDesc = Lists.newArrayList();
        if (maidTask != TaskManager.getIdleTask()) {
            if (((MaidTaskEnableEvent)NeoForge.EVENT_BUS.post((Event)new MaidTaskEnableEvent(maidTask, this.maid, enableConditionDesc))).isCanceled()) {
                enable[0] = false;
            } else if (!maidTask.isEnable(this.maid)) {
                enableConditionDesc.addAll(maidTask.getEnableConditionDesc(this.maid));
                enable[0] = false;
            }
        }
        TaskButton button = new TaskButton(maidTask, enable[0], this.leftPos - 89, this.topPos + 23 + 19 * count, 83, 19, 93, 28, 20, TASK, 256, 256, b -> this.taskButtonPressed(maidTask, enable[0]), this.getTaskTooltips(maidTask, enable[0], enableConditionDesc), (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)button);
        button.visible = TASK_LIST_OPEN;
    }

    protected void taskButtonPressed(IMaidTask maidTask, boolean enable) {
        if (enable && this.maid != null) {
            this.maid.setTask(maidTask);
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidTaskPackage(this.maid.getId(), maidTask.getUid()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private List<Component> getTaskTooltips(IMaidTask maidTask, boolean enable, List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc) {
        List<Pair<String, Predicate<EntityMaid>>> conditions;
        List<Component> desc = ParseI18n.keysToTrans(maidTask.getDescription(this.maid), ChatFormatting.GRAY);
        if (!desc.isEmpty()) {
            desc.addFirst((Component)Component.translatable((String)"task.touhou_little_maid.desc.title").withStyle(ChatFormatting.GOLD));
        }
        if (!enable) {
            desc.add((Component)Component.literal((String)" "));
            desc.add((Component)Component.translatable((String)"task.touhou_little_maid.desc.enable_condition").withStyle(ChatFormatting.GOLD));
            for (Pair<String, Predicate<EntityMaid>> line : enableConditionDesc) {
                MutableComponent prefix = Component.literal((String)"- ");
                String key = String.format("task.%s.%s.enable_condition.%s", maidTask.getUid().getNamespace(), maidTask.getUid().getPath(), line.getFirst());
                MutableComponent condition = Component.translatable((String)key);
                if (((Predicate)line.getSecond()).test(this.maid)) {
                    condition.withStyle(ChatFormatting.GREEN);
                } else {
                    condition.withStyle(ChatFormatting.RED);
                }
                desc.add((Component)prefix.append((Component)condition));
            }
        }
        if (!(conditions = maidTask.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((Component)Component.literal((String)" "));
            desc.add((Component)Component.translatable((String)"task.touhou_little_maid.desc.condition").withStyle(ChatFormatting.GOLD));
        }
        for (Pair<String, Predicate<EntityMaid>> line : conditions) {
            MutableComponent prefix = Component.literal((String)"- ");
            String key = String.format("task.%s.%s.condition.%s", maidTask.getUid().getNamespace(), maidTask.getUid().getPath(), line.getFirst());
            MutableComponent condition = Component.translatable((String)key);
            if (((Predicate)line.getSecond()).test(this.maid)) {
                condition.withStyle(ChatFormatting.GREEN);
            } else {
                condition.withStyle(ChatFormatting.RED);
            }
            desc.add((Component)prefix.append((Component)condition));
        }
        if (this.getMinecraft().options.advancedItemTooltips) {
            desc.add(CommonComponents.SPACE);
            desc.add((Component)Component.translatable((String)"task.touhou_little_maid.advanced.id", (Object[])new Object[]{maidTask.getUid().getPath()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        return desc;
    }

    private void addScheduleButton() {
        this.scheduleButton = new ScheduleButton(this.leftPos + 9, this.topPos + 187, this);
        this.addRenderableWidget((GuiEventListener)this.scheduleButton);
    }

    private void addTabsButton() {
        MaidTabButton[] tabs;
        MaidTabs maidTabs = new MaidTabs(this.maid.getId(), this.leftPos, this.topPos);
        for (MaidTabButton button : tabs = maidTabs.getTabs(this)) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void addTaskSwitchButton() {
        this.taskSwitch = new TouhouImageButton(this.leftPos + 4, this.topPos + 159, 71, 21, 0, 42, 22, BUTTON, b -> {
            TASK_LIST_OPEN = !TASK_LIST_OPEN;
            this.init();
        });
        this.addRenderableWidget((GuiEventListener)this.taskSwitch);
    }

    private void addRideButton() {
        this.ride = new TouhouStateSwitchButton(this.leftPos + 51, this.topPos + 206, 20, 20, this.maid.isRideable()){

            public void onClick(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                PacketDistributor.sendToServer((CustomPacketPayload)new MaidConfigPackage(AbstractMaidContainerGui.this.maid.getId(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), AbstractMaidContainerGui.this.maid.isPickup(), this.isStateTriggered, AbstractMaidContainerGui.this.maid.getSchedule()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
        this.ride.initTextureValues(84, 0, 21, 21, BUTTON);
        this.addRenderableWidget((GuiEventListener)this.ride);
    }

    private void addPickButton() {
        this.pick = new TouhouStateSwitchButton(this.leftPos + 30, this.topPos + 206, 20, 20, this.maid.isPickup()){

            public void onClick(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                PacketDistributor.sendToServer((CustomPacketPayload)new MaidConfigPackage(AbstractMaidContainerGui.this.maid.getId(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), this.isStateTriggered, AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
        this.pick.initTextureValues(42, 0, 21, 21, BUTTON);
        this.addRenderableWidget((GuiEventListener)this.pick);
    }

    private void addHomeButton() {
        this.home = new TouhouStateSwitchButton(this.leftPos + 9, this.topPos + 206, 20, 20, this.maid.isHomeModeEnable()){

            public void onClick(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                PacketDistributor.sendToServer((CustomPacketPayload)new MaidConfigPackage(AbstractMaidContainerGui.this.maid.getId(), this.isStateTriggered, AbstractMaidContainerGui.this.maid.isPickup(), AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
        this.home.initTextureValues(0, 0, 21, 21, BUTTON);
        this.addRenderableWidget((GuiEventListener)this.home);
    }

    private void addDownloadButton() {
        this.modelDownload = new MaidDownloadButton(this.leftPos + 20, this.topPos + 230, BUTTON, this.maid);
        this.addRenderableWidget((GuiEventListener)this.modelDownload);
    }

    private void drawTaskPageCount(GuiGraphics graphics) {
        if (TASK_LIST_OPEN) {
            String text = String.format("%d/%d", TASK_PAGE + 1, (this.notHiddenTasks.size() - 1) / 12 + 1);
            graphics.drawString(this.font, text, -48, 12, 0x333333, false);
        }
    }

    private void drawCurrentTaskText(GuiGraphics graphics) {
        IMaidTask task = this.maid.getTask();
        graphics.renderItem(task.getIcon(), this.leftPos + 6, this.topPos + 161);
        List splitTexts = this.font.split((FormattedText)task.getName(), 42);
        if (!splitTexts.isEmpty()) {
            graphics.drawString(this.font, (FormattedCharSequence)splitTexts.getFirst(), this.leftPos + 28, this.topPos + 165, 0x333333, false);
        }
    }

    private void renderMaidInfo(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.info.isHovered()) {
            ArrayList list = Lists.newArrayList();
            String prefix = "\u00a7a\u2588 ";
            MutableComponent title = Component.literal((String)"").append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE})).append((Component)Component.literal((String)"\u00a7r "));
            if (this.maid.isStruckByLightning()) {
                title.append((Component)Component.literal((String)"\u2740").withStyle(ChatFormatting.DARK_RED));
            }
            if (this.maid.isInvulnerable()) {
                title.append((Component)Component.literal((String)"\u271f").withStyle(ChatFormatting.BLUE));
            }
            list.add(title);
            if (this.maid.getOwner() != null) {
                list.add(Component.literal((String)prefix).withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.owner").append(": ").withStyle(ChatFormatting.AQUA)).append(this.maid.getOwner().getDisplayName()));
            }
            CustomPackLoader.MAID_MODELS.getInfo(this.maid.getModelId()).ifPresent(info -> list.add(Component.literal((String)prefix).withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.model_name").append(": ").withStyle(ChatFormatting.AQUA)).append((Component)ParseI18n.parse(info.getName()))));
            list.add(Component.literal((String)prefix).withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.experience").append(": ").withStyle(ChatFormatting.AQUA)).append(String.valueOf(this.maid.getExperience())));
            list.add(Component.literal((String)prefix).withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.favorability").append(": ").withStyle(ChatFormatting.AQUA)).append(String.valueOf(this.maid.getFavorability())));
            list.add(Component.literal((String)prefix).withStyle(ChatFormatting.WHITE).append((Component)Component.translatable((String)"block.touhou_little_maid.gomoku").append(": ").withStyle(ChatFormatting.AQUA)).append((Component)Component.translatable((String)"tooltips.touhou_little_maid.info.game_skill.gomoku", (Object[])new Object[]{this.maid.getGameRecordManager().getGomokuWinCount(), MaidGomokuAI.getRank(this.maid)})));
            graphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        }
    }

    private void renderScheduleInfo(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.scheduleButton.isHovered()) {
            graphics.renderComponentTooltip(this.font, this.scheduleButton.getTooltips(), mouseX, mouseY);
        }
    }

    private void renderTaskButtonInfo(GuiGraphics graphics, int x, int y) {
        this.renderables.stream().filter(b -> b instanceof ITooltipButton).forEach(b -> {
            ITooltipButton tooltipButton = (ITooltipButton)b;
            if (tooltipButton.isTooltipHovered()) {
                tooltipButton.renderTooltip(graphics, this.getMinecraft(), x, y);
            }
        });
    }

    private void drawMaidCharacter(GuiGraphics graphics, int x, int y) {
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.leftPos + 6), (int)(this.topPos + 12), (int)(this.leftPos + 73), (int)(this.topPos + 124), (int)40, (float)0.1f, (float)x, (float)y, (LivingEntity)this.maid);
    }

    private void drawTaskListBg(GuiGraphics graphics) {
        if (TASK_LIST_OPEN) {
            Rect2i taskListArea = this.getTaskListArea();
            graphics.blit(TASK, taskListArea.getX(), taskListArea.getY(), 0, 0, taskListArea.getWidth(), taskListArea.getHeight());
        }
    }

    private void drawBaseInfoGui(GuiGraphics graphics) {
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.blit(SIDE, this.leftPos + 53, this.topPos + 113, 0, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5, this.topPos + 113, 0, 9, 47, 9);
        double hp = this.maid.getHealth() / this.maid.getMaxHealth();
        graphics.blit(SIDE, this.leftPos + 7, this.topPos + 115, 2, 18, (int)(43.0 * hp), 5);
        this.drawNumberScale(graphics, this.maid.getHealth(), this.leftPos + 63, this.topPos + 114);
        graphics.blit(SIDE, this.leftPos + 53, this.topPos + 124, 9, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5, this.topPos + 124, 0, 9, 47, 9);
        double armor = Math.min(this.maid.getAttributeValue(Attributes.ARMOR) / 20.0, 1.0);
        graphics.blit(SIDE, this.leftPos + 7, this.topPos + 126, 2, 23, (int)(43.0 * armor), 5);
        this.drawNumberScale(graphics, this.maid.getArmorValue(), this.leftPos + 63, this.topPos + 125);
        graphics.blit(SIDE, this.leftPos + 53, this.topPos + 135, 18, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5, this.topPos + 135, 0, 9, 47, 9);
        int exp = this.maid.getExperience();
        int count = exp / 120;
        double percent = (double)(exp % 120) / 120.0;
        graphics.blit(SIDE, this.leftPos + 7, this.topPos + 137, 2, 28, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, count, this.leftPos + 63, this.topPos + 136);
        graphics.blit(SIDE, this.leftPos + 53, this.topPos + 146, 27, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5, this.topPos + 146, 0, 9, 47, 9);
        FavorabilityManager manager = this.maid.getFavorabilityManager();
        double percent2 = manager.getLevelPercent();
        graphics.blit(SIDE, this.leftPos + 7, this.topPos + 148, 2, 33, (int)(43.0 * percent2), 5);
        this.drawNumberScale(graphics, manager.getLevel(), this.leftPos + 63, this.topPos + 147);
        graphics.blit(SIDE, this.leftPos + 94, this.topPos + 7, 107, 0, 149, 21);
        graphics.blit(SIDE, this.leftPos + 6, this.topPos + 178, 0, 47, 67, 25);
    }

    private void drawNumberScale(GuiGraphics graphics, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, text, posX * 2, posY * 2 + 9 / 2, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
        graphics.pose().popPose();
    }

    protected void containerTick() {
        ++this.counterTime;
        if (this.counterTime % 20 == 0 && this.maid != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestEffectPackage(this.maid.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isTaskListOpen() {
        return TASK_LIST_OPEN;
    }

    private Rect2i getTaskListArea() {
        return new Rect2i(this.leftPos - 93, this.topPos + 5, 92, 251);
    }

    public List<Rect2i> getExclusionArea() {
        ArrayList<Rect2i> zones = new ArrayList<Rect2i>();
        zones.add(new Rect2i(this.leftPos + 251, this.topPos + 28 + 9, 21, 99));
        if (this.isTaskListOpen()) {
            zones.add(this.getTaskListArea());
        }
        return zones;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (TASK_LIST_OPEN && this.getTaskListArea().contains((int)mouseX, (int)mouseY)) {
            if (scrollY > 0.0) {
                this.taskPageUp();
            } else {
                this.taskPageDown();
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    private void renderTransTooltip(TouhouImageButton button, GuiGraphics graphics, int x, int y, String key) {
        if (button.isHovered()) {
            graphics.renderComponentTooltip(this.font, Collections.singletonList(Component.translatable((String)key)), x, y);
        }
    }

    private void renderTransTooltip(TouhouStateSwitchButton button, GuiGraphics graphics, int x, int y, String key) {
        if (button.isHovered()) {
            graphics.renderComponentTooltip(this.font, (List)Lists.newArrayList((Object[])new Component[]{Component.translatable((String)(key + "." + button.isStateTriggered())), Component.translatable((String)(key + ".desc"))}), x, y);
        }
    }

    private void addSideTabsButton() {
        MaidSideTabButton[] tabs;
        MaidSideTabs maidTabs = new MaidSideTabs(this.maid.getId(), this.leftPos + 251, this.topPos + 28 + 9);
        for (MaidSideTabButton button : tabs = maidTabs.getTabs(this)) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void drawSideTabGui(GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(SIDE, this.leftPos + 251 + 5, this.topPos + 28 + 9, 235, 107, 21, 50);
    }
}

