/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.MaidModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ModelSwitcherModelGui
extends AbstractModelGui<EntityMaid, MaidModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;
    private final TileEntityModelSwitcher.ModeInfo infoIn;
    private final ModelSwitcherGui modelSwitcherGui;

    public ModelSwitcherModelGui(EntityMaid maid, TileEntityModelSwitcher.ModeInfo infoIn, ModelSwitcherGui modelSwitcherGui) {
        super(maid, CustomPackLoader.MAID_MODELS.getPackList());
        this.infoIn = infoIn;
        this.modelSwitcherGui = modelSwitcherGui;
    }

    @Override
    protected void drawLeftEntity(GuiGraphics graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(((EntityMaid)this.entity).getModelId());
        int centerX = (middleX - 128) / 2;
        int yOffset = (int)(45.0f * (renderItemScale - 1.0f));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(centerX - 100), (int)(middleY - 100), (int)(centerX + 100), (int)(middleY + 200 - yOffset), (int)((int)(45.0f * renderItemScale)), (float)0.1f, (float)mouseX, (float)mouseY, (LivingEntity)this.entity);
    }

    @Override
    protected void drawRightEntity(GuiGraphics graphics, int posX, int posY, MaidModelInfo modelItem) {
        ResourceLocation cacheIconId = modelItem.getCacheIconId();
        Map allTextures = Minecraft.getInstance().getTextureManager().byPath;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.blit(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityMaid maid, MaidModelInfo modelInfo) {
        if (this.minecraft != null && modelInfo.getEasterEgg() == null) {
            this.minecraft.setScreen((Screen)new MaidModelDetailsGui(maid, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityMaid maid, MaidModelInfo info) {
        if (info.getEasterEgg() == null) {
            maid.setModelId(info.getModelId().toString());
            this.infoIn.setModelId(info.getModelId());
            this.getMinecraft().setScreen((Screen)this.modelSwitcherGui);
        }
    }

    @Override
    protected void addModelCustomTips(MaidModelInfo modelItem, List<Component> tooltips) {
        String useSoundPackId = modelItem.getUseSoundPackId();
        if (StringUtils.isNotBlank((CharSequence)useSoundPackId)) {
            tooltips.add((Component)Component.translatable((String)"gui.touhou_little_maid.skin.tooltips.maid_use_sound_pack_id", (Object[])new Object[]{useSoundPackId}).withStyle(ChatFormatting.GOLD));
        }
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(GuiGraphics graphics, int posX, int posY, MaidModelInfo modelItem) {
        EntityMaid maid;
        ClientLevel world = this.getMinecraft().level;
        if (world == null) {
            return;
        }
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ModelSwitcherModelGui.lambda$drawEntity$1((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelItem.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelItem.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(posX - 10), (int)(posY - 32), (int)(posX + 10), (int)(posY + 12), (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)0.1f, (float)(posX + 25), (float)(posY + 5), (LivingEntity)maid);
    }

    private static /* synthetic */ Entity lambda$drawEntity$1(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.create(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

