/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class MaidAreaRenderEvent {
    private static final Cache<Integer, SchedulePos> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || mc.level == null) {
                return;
            }
            Vec3 camera = event.getCamera().getPosition().reverse();
            PoseStack poseStack = event.getPoseStack();
            Iterator iterator = CACHE.asMap().keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                SchedulePos pos = (SchedulePos)CACHE.getIfPresent((Object)id);
                if (pos == null) continue;
                Entity entity = mc.level.getEntity(id);
                if (!(entity instanceof EntityMaid)) {
                    return;
                }
                EntityMaid maid = (EntityMaid)entity;
                ResourceLocation dimension = pos.getDimension();
                if (!mc.player.level.dimension().location().equals((Object)dimension)) continue;
                MaidAreaRenderEvent.renderPos(pos.getWorkPos(), pos.getIdlePos(), pos.getSleepPos(), camera, poseStack, mc, maid, (Player)mc.player);
            }
        }
    }

    private static void renderPos(@Nullable BlockPos workPos, @Nullable BlockPos idlePos, @Nullable BlockPos resetPos, Vec3 camera, PoseStack poseStack, Minecraft mc, EntityMaid maid, Player player) {
        Vec3 prePos;
        String text;
        Vec3 textPos;
        VertexConsumer buffer;
        double radius;
        Vec3 centerPos;
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.0f, 0.0f);
        BlockPos restrictCenter = maid.getRestrictCenter();
        Vec3 restrictPos = camera.add((double)restrictCenter.getX() + 0.5, (double)restrictCenter.getY() + 0.5, (double)restrictCenter.getZ() + 0.5);
        if (!maid.isHomeModeEnable()) {
            restrictPos = camera.add(player.position());
        }
        Vec3 maidPos = camera.add(maid.position());
        RenderHelper.renderLine(poseStack, mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES), restrictPos, maidPos, 1.0f, 0.2f, 0.2f);
        AABB aabb = maid.getBoundingBox().move(0.0, -1.0, 0.0).move(camera);
        DebugRenderer.renderFilledBox((PoseStack)poseStack, (MultiBufferSource)mc.renderBuffers().bufferSource(), (AABB)aabb, (float)0.8f, (float)0.8f, (float)0.2f, (float)0.75f);
        if (workPos != null) {
            centerPos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
            buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
            textPos = new Vec3((double)workPos.getX() + 0.5, (double)(workPos.getY() + 2), (double)workPos.getZ() + 0.5);
            text = I18n.get((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.x, textPos.y, textPos.z, 0xFF1111, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.x, textPos.y, textPos.z, 0xFF1111, 0.15f, true, 5.0f, false);
        }
        if (idlePos != null) {
            centerPos = camera.add((double)idlePos.getX() + 0.5, (double)idlePos.getY() + 0.5, (double)idlePos.getZ() + 0.5);
            radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
            buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
            textPos = new Vec3((double)idlePos.getX() + 0.5, (double)(idlePos.getY() + 2), (double)idlePos.getZ() + 0.5);
            if (idlePos.equals((Object)workPos)) {
                textPos = textPos.add(0.0, 1.0, 0.0);
            } else if (workPos != null) {
                prePos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.get((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.x, textPos.y, textPos.z, 0x11FF11, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.x, textPos.y, textPos.z, 0x11FF11, 0.15f, true, 5.0f, false);
        }
        if (resetPos != null) {
            centerPos = camera.add((double)resetPos.getX() + 0.5, (double)resetPos.getY() + 0.5, (double)resetPos.getZ() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
            buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
            textPos = new Vec3((double)resetPos.getX() + 0.5, (double)(resetPos.getY() + 2), (double)resetPos.getZ() + 0.5);
            if (resetPos.equals((Object)idlePos)) {
                textPos = textPos.add(0.0, 2.0, 0.0);
            } else if (idlePos != null && workPos != null) {
                prePos = camera.add((double)idlePos.getX() + 0.5, (double)idlePos.getY() + 0.5, (double)idlePos.getZ() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.get((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.x, textPos.y, textPos.z, 0x1111FF, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.x, textPos.y, textPos.z, 0x1111FF, 0.15f, true, 5.0f, false);
        }
        poseStack.popPose();
    }

    public static void addSchedulePos(int id, SchedulePos pos) {
        CACHE.put((Object)id, (Object)pos);
    }
}

