/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMaidData;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public final class EntityMaidWrapper
implements IMaidData {
    private final WorldWrapper world = new WorldWrapper();
    private final float[] handRotation = new float[]{0.0f, 0.0f, 0.0f};
    private float swingProgress;
    private boolean isRiding;
    private IMaid maid;

    public void setData(IMaid maid, float swingProgress, boolean isRiding) {
        this.maid = maid;
        this.swingProgress = swingProgress;
        this.isRiding = isRiding;
        this.world.setData(maid.asEntity().level());
    }

    public void clearData() {
        this.maid = null;
        this.world.clearData();
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public String getTask() {
        return this.maid.getTask().getUid().toString();
    }

    @Override
    public boolean hasHelmet() {
        return this.maid.hasHelmet();
    }

    @Override
    public String getHelmet() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getItemBySlot(EquipmentSlot.HEAD).getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasChestPlate() {
        return this.maid.hasChestPlate();
    }

    @Override
    public String getChestPlate() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getItemBySlot(EquipmentSlot.CHEST).getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasLeggings() {
        return this.maid.hasLeggings();
    }

    @Override
    public String getLeggings() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getItemBySlot(EquipmentSlot.LEGS).getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasBoots() {
        return this.maid.hasBoots();
    }

    @Override
    public String getBoots() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getItemBySlot(EquipmentSlot.FEET).getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemMainhand() {
        return this.maid.asEntity().getMainHandItem().isEmpty();
    }

    @Override
    public String getItemMainhand() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getMainHandItem().getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemOffhand() {
        return this.maid.asEntity().getOffhandItem().isEmpty();
    }

    @Override
    public String getItemOffhand() {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this.maid.asEntity().getOffhandItem().getItem());
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean isBegging() {
        return this.maid.isBegging();
    }

    @Override
    public boolean isSwingingArms() {
        return this.maid.isSwingingArms();
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isSitting() {
        return this.maid.isMaidInSittingPose();
    }

    @Override
    public boolean hasBackpack() {
        return this.maid.hasBackpack();
    }

    @Override
    @Deprecated
    public int getBackpackLevel() {
        return 0;
    }

    @Override
    public boolean inWater() {
        return this.maid.asEntity().isInWater();
    }

    @Override
    public boolean inRain() {
        return this.maid.asEntity().level().isRainingAt(this.maid.asEntity().blockPosition());
    }

    @Override
    public boolean isSwingLeftHand() {
        return this.maid.asEntity().swingingArm == InteractionHand.OFF_HAND;
    }

    @Override
    public float getSwingProgress() {
        return this.swingProgress;
    }

    @Override
    public float getHealth() {
        return this.maid.asEntity().getHealth();
    }

    @Override
    public float getMaxHealth() {
        return this.maid.asEntity().getMaxHealth();
    }

    @Override
    public double getArmorValue() {
        return this.maid.asEntity().getAttributeValue(Attributes.ARMOR);
    }

    @Override
    public boolean onHurt() {
        return this.maid.asEntity().hurtTime > 0;
    }

    @Override
    public boolean isSleep() {
        return this.maid.asEntity().isSleeping();
    }

    @Override
    public int getFavorability() {
        return this.maid.getFavorability();
    }

    @Override
    public long getSeed() {
        return Math.abs(this.maid.asEntity().getUUID().getLeastSignificantBits());
    }

    @Override
    public Biome getAtBiome() {
        return BiomeCacheUtil.getCacheBiome((Entity)this.maid.asEntity());
    }

    @Override
    public boolean isOnGround() {
        return !this.maid.asEntity().onGround();
    }

    @Override
    @Deprecated
    public String getAtBiomeTemp() {
        return this.maid.getAtBiomeTemp();
    }

    @Override
    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isHoldTrolley() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isRidingMarisaBroom() {
        return false;
    }

    @Override
    public boolean isRidingPlayer() {
        return this.maid.asEntity().getVehicle() instanceof Player;
    }

    @Override
    @Deprecated
    public boolean isHoldVehicle() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isPortableAudioPlay() {
        return false;
    }

    @Override
    @Deprecated
    public float[] getLeftHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public float[] getRightHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public int getDim() {
        return this.maid.getDim();
    }
}

