/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.neoforged.neoforge.common.ModConfigSpec;

public interface IRangedAttackTask
extends IAttackTask {
    public static final TargetingConditions TARGET_CONDITIONS = TargetingConditions.forCombat();

    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        LivingEntity lastAttacker = maid.getLastHurtByMob();
        if (lastAttacker != null && maid.canAttack(lastAttacker) && maid.canSee(lastAttacker)) {
            return Optional.of(lastAttacker);
        }
        Optional memory = maid.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        if (memory.isEmpty()) {
            return Optional.empty();
        }
        for (LivingEntity e : (List)memory.get()) {
            if (!maid.canAttack(e) || !maid.canSee(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean targetConditionsTest(EntityMaid maid, LivingEntity target, ModConfigSpec.IntValue configRange) {
        TARGET_CONDITIONS.range((double)((Integer)configRange.get()).intValue());
        return TARGET_CONDITIONS.test((LivingEntity)maid, target);
    }

    public void performRangedAttack(EntityMaid var1, LivingEntity var2, float var3);

    default public boolean canSee(EntityMaid maid, LivingEntity target) {
        return BehaviorUtils.canSee((LivingEntity)maid, (LivingEntity)target);
    }
}

