/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.chess;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Util;

public class Evaluate {
    public static final int PIECE_KING = 0;
    public static final int PIECE_QUEEN = 1;
    public static final int PIECE_ROOK = 2;
    public static final int PIECE_BISHOP = 3;
    public static final int PIECE_KNIGHT = 4;
    public static final int PIECE_PAWN = 5;
    public static final int FULL_BIT_RANK = 4080;
    public static final int LAZY_MARGIN = 100;
    public static final int ISOLATED_PENALTY = 10;
    public static final int DOUBLE_PENALTY = 4;
    public static final int[] PIECE_VALUE = new int[]{0, 9, 5, 3, 3, 1};
    public static final int[] PASS_PAWN = new int[]{0, 35, 30, 20, 10, 5, 0, 0};
    public static final byte[] DISTANCE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 5, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 5, 4, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 7, 6, 5, 4, 3, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 7, 6, 5, 4, 3, 2, 1, 2, 3, 4, 5, 6, 7, 0, 0, 7, 6, 5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 6, 7, 0, 0, 7, 6, 5, 4, 3, 2, 1, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 7, 6, 5, 4, 3, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 7, 6, 5, 4, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 5, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] ENDGAME_EDGE = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0};
    public static final byte[] ENDGAME_BOTTOM = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0};
    public static final byte[] ENDGAME_KING_PENALTY = new byte[]{0, 0, 0, 0, 25, 22, 19, 16, 16, 19, 22, 25, 0, 0, 0, 0, 0, 0, 0, 0, 17, 14, 11, 8, 8, 11, 14, 17, 0, 0, 0, 0, 0, 0, 0, 0, 13, 10, 7, 4, 4, 7, 10, 13, 0, 0, 0, 0, 0, 0, 0, 0, 9, 6, 3, 0, 0, 3, 6, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 6, 3, 0, 0, 3, 6, 9, 0, 0, 0, 0, 0, 0, 0, 0, 13, 10, 7, 4, 4, 7, 10, 13, 0, 0, 0, 0, 0, 0, 0, 0, 17, 14, 11, 8, 8, 11, 14, 17, 0, 0, 0, 0, 0, 0, 0, 0, 25, 22, 19, 16, 16, 19, 22, 25, 0, 0, 0, 0};
    public static final byte[] EDGE_PENALTY = new byte[]{0, 0, 0, 0, 6, 5, 4, 3, 3, 4, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 3, 2, 2, 3, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 2, 1, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1, 0, 0, 1, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1, 0, 0, 1, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 2, 1, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 3, 2, 2, 3, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 6, 5, 4, 3, 3, 4, 5, 6, 0, 0, 0, 0};
    public static final byte[] PAWN_VALUE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 30, 46, 70, 78, 46, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 22, 43, 50, 22, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 16, 34, 40, 16, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 12, 27, 32, 12, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 20, 24, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 15, 18, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] CENTER_IMPORTANCE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 8, 8, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 8, 8, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] RANK_IMPORTANCE = new byte[]{0, 0, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static boolean IN_BOARD(int sq) {
        return Position.IN_BOARD(sq);
    }

    public static int SQUARE_FLIP(int sq) {
        return Position.SQUARE_FLIP(sq);
    }

    public static int losingKingValue(int sq) {
        return -ENDGAME_KING_PENALTY[sq] * 2 - ENDGAME_BOTTOM[sq] * 8;
    }

    public static int winningKingValue(int sq, int sqOppKing) {
        return -DISTANCE[sqOppKing - sq + 128] * 2 - ENDGAME_EDGE[sq] * 8;
    }

    public static int calcRookControl(Position pos, int sqSrc, short[] attack) {
        return Evaluate.calcSlideControl(pos, sqSrc, attack, true);
    }

    public static int calcBishopControl(Position pos, int sqSrc, short[] attack) {
        return Evaluate.calcSlideControl(pos, sqSrc, attack, false);
    }

    public static int calcSlideControl(Position pos, int sqSrc, short[] attack, boolean isRook) {
        int control = 0;
        block0: for (int i = 0; i < 4; ++i) {
            int delta = isRook ? Position.ROOK_DELTA[i] : Position.BISHOP_DELTA[i];
            int sqDst = sqSrc + delta;
            boolean direct = true;
            while (Evaluate.IN_BOARD(sqDst)) {
                control += direct ? attack[sqDst] : attack[sqDst] / 2;
                if (pos.squares[sqDst] > 0) {
                    int pieceType = Position.PIECE_TYPE(pos.squares[sqDst]);
                    if (pieceType == 5) continue block0;
                    if (pieceType == 0 || pieceType == 4 || pieceType == (isRook ? 3 : 2)) {
                        direct = false;
                    }
                }
                sqDst += delta;
            }
        }
        return control;
    }

    public static void preEval(Position pos) {
        int sq;
        int vlWhite = 0;
        int vlBlack = 0;
        int sqWhiteKing = 0;
        int sqBlackKing = 0;
        for (int sq2 = 0; sq2 < 128; ++sq2) {
            byte pc = pos.squares[sq2];
            if (pc == 0) continue;
            if (pc < 16) {
                vlWhite += PIECE_VALUE[pc - 8];
                if (pc != 8) continue;
                sqWhiteKing = sq2;
                continue;
            }
            vlBlack += PIECE_VALUE[pc - 16];
            if (pc != 16) continue;
            sqBlackKing = sq2;
        }
        boolean inEndgame = Math.min(vlWhite, vlBlack) <= 6 && Math.abs(vlWhite - vlBlack) >= 2;
        short[] whiteAttack = new short[128];
        short[] blackAttack = new short[128];
        for (int sq3 = 0; sq3 < 128; ++sq3) {
            short s = (short)(RANK_IMPORTANCE[sq3] * Math.max(vlWhite + vlBlack - 24, 8) / 32 + CENTER_IMPORTANCE[sq3]);
            blackAttack[Evaluate.SQUARE_FLIP((int)sq3)] = s;
            whiteAttack[sq3] = s;
        }
        for (int i = 0; i < 8; ++i) {
            int importance = 12 * Math.max(vlWhite + vlBlack - 24, 8) / 32;
            int sq4 = sqWhiteKing + Position.KING_DELTA[i];
            if (Evaluate.IN_BOARD(sq4)) {
                int n = sq4;
                blackAttack[n] = (short)(blackAttack[n] + importance);
            }
            if (!Evaluate.IN_BOARD(sq4 = sqBlackKing + Position.KING_DELTA[i])) continue;
            int n = sq4;
            whiteAttack[n] = (short)(whiteAttack[n] + importance);
        }
        short[] whiteRookControl = new short[128];
        short[] whiteBishopControl = new short[128];
        short[] blackRookControl = new short[128];
        short[] blackBishopControl = new short[128];
        for (sq = 0; sq < 128; ++sq) {
            if (!Evaluate.IN_BOARD(sq)) continue;
            whiteRookControl[sq] = (short)Evaluate.calcRookControl(pos, sq, whiteAttack);
            blackRookControl[sq] = (short)Evaluate.calcRookControl(pos, sq, blackAttack);
            whiteBishopControl[sq] = (short)Evaluate.calcBishopControl(pos, sq, whiteAttack);
            blackBishopControl[sq] = (short)Evaluate.calcBishopControl(pos, sq, blackAttack);
        }
        for (sq = 0; sq < 128; ++sq) {
            if (!Evaluate.IN_BOARD(sq)) continue;
            byte edgePenalty = EDGE_PENALTY[sq];
            if (inEndgame) {
                if (vlWhite < vlBlack) {
                    pos.vlWhitePiecePos[0][sq] = (short)Evaluate.losingKingValue(sq);
                    pos.vlBlackPiecePos[0][sq] = (short)Evaluate.winningKingValue(sq, sqWhiteKing);
                } else {
                    pos.vlBlackPiecePos[0][sq] = (short)Evaluate.losingKingValue(sq);
                    pos.vlWhitePiecePos[0][sq] = (short)Evaluate.winningKingValue(sq, sqBlackKing);
                }
                for (int i = 1; i <= 4; ++i) {
                    short s = (short)(PIECE_VALUE[i] * 100);
                    pos.vlBlackPiecePos[i][sq] = s;
                    pos.vlWhitePiecePos[i][sq] = s;
                }
            } else {
                if (vlWhite + vlBlack <= 32) {
                    short s = -edgePenalty;
                    pos.vlBlackPiecePos[0][sq] = s;
                    pos.vlWhitePiecePos[0][sq] = s;
                } else {
                    pos.vlBlackPiecePos[0][sq] = 0;
                    pos.vlWhitePiecePos[0][sq] = 0;
                }
                pos.vlWhitePiecePos[1][sq] = (short)(PIECE_VALUE[1] * 100 + (whiteRookControl[sq] + whiteBishopControl[sq]) / 8);
                pos.vlBlackPiecePos[1][sq] = (short)(PIECE_VALUE[1] * 100 + (blackRookControl[sq] + blackBishopControl[sq]) / 8);
                pos.vlWhitePiecePos[2][sq] = (short)(PIECE_VALUE[2] * 100 + whiteRookControl[sq] / 2);
                pos.vlBlackPiecePos[2][sq] = (short)(PIECE_VALUE[2] * 100 + blackRookControl[sq] / 2);
                pos.vlWhitePiecePos[3][sq] = (short)(PIECE_VALUE[3] * 100 + whiteBishopControl[sq] / 2);
                pos.vlBlackPiecePos[3][sq] = (short)(PIECE_VALUE[3] * 100 + blackBishopControl[sq] / 2);
                int whiteKnightAttack = 0;
                int blackKnightAttack = 0;
                for (int i = 0; i < 8; ++i) {
                    int sqDst = sq + Position.KNIGHT_DELTA[i];
                    if (!Evaluate.IN_BOARD(sqDst)) continue;
                    whiteKnightAttack += whiteAttack[sqDst];
                    blackKnightAttack += blackAttack[sqDst];
                }
                pos.vlWhitePiecePos[4][sq] = (short)(PIECE_VALUE[4] * 100 + whiteKnightAttack / 4 - edgePenalty * 3 / 2);
                pos.vlBlackPiecePos[4][sq] = (short)(PIECE_VALUE[4] * 100 + blackKnightAttack / 4 - edgePenalty * 3 / 2);
            }
            short s = (short)(PIECE_VALUE[5] * 100 + PAWN_VALUE[sq] / 2 - 6);
            pos.vlBlackPiecePos[5][Evaluate.SQUARE_FLIP((int)sq)] = s;
            pos.vlWhitePiecePos[5][sq] = s;
        }
        for (int sd = 0; sd < 2; ++sd) {
            int brSelf = 0;
            int brSide = 0;
            int brBehindOppPass = 0;
            int brOppPass = 4080;
            for (int i = 1; i <= 6; ++i) {
                int y = sd == 0 ? 7 - i : i;
                int brOpp = sd == 0 ? pos.brBlackPawn[y] : pos.brWhitePawn[y];
                brBehindOppPass |= (brOppPass &= ~(brSelf | brSide)) & brOpp;
                int brChain = brSide;
                brSelf = sd == 0 ? pos.brWhitePawn[y] : pos.brBlackPawn[y];
                brSide = (brSelf >> 1 | brSelf << 1) & 0xFF0;
                int brForward = sd == 0 ? pos.brWhitePawn[y + 1] : pos.brBlackPawn[y + 1];
                int brLeftCover = brForward >> 1 & 0xFF0;
                int brRightCover = brForward << 1 & 0xFF0;
                for (int x = 4; x <= 11; ++x) {
                    int sq5 = Position.COORD_XY(x, y);
                    int brSquare = 1 << x;
                    int value = ((brSide & brSquare) != 0 ? 3 : 0) + ((brChain & brSquare) != 0 ? 2 : 0);
                    value += ((brLeftCover & brSquare) != 0 ? 2 : 0) + ((brRightCover & brSquare) != 0 ? 2 : 0);
                    value += (brSelf & brSquare) != 0 ? 1 : 0;
                    if (sd == 0) {
                        short[] sArray = pos.vlWhitePiecePos[5];
                        int n = sq5;
                        sArray[n] = (short)(sArray[n] + value);
                    } else {
                        short[] sArray = pos.vlBlackPiecePos[5];
                        int n = sq5;
                        sArray[n] = (short)(sArray[n] + value);
                    }
                    if (vlWhite + vlBlack > 32) continue;
                    if ((brOppPass & brSquare) != 0) {
                        if (sd == 0) {
                            short[] sArray = pos.vlBlackPiecePos[5];
                            int n = sq5;
                            sArray[n] = (short)(sArray[n] + PASS_PAWN[i]);
                        } else {
                            short[] sArray = pos.vlWhitePiecePos[5];
                            int n = sq5;
                            sArray[n] = (short)(sArray[n] + PASS_PAWN[i]);
                        }
                    }
                    if ((brBehindOppPass & brSquare) == 0) continue;
                    short[] sArray = pos.vlWhitePiecePos[2];
                    int n = sq5;
                    sArray[n] = (short)(sArray[n] + 8);
                    short[] sArray2 = pos.vlBlackPiecePos[2];
                    int n2 = sq5;
                    sArray2[n2] = (short)(sArray2[n2] + 8);
                    if (i != 6) continue;
                    int sqBottom = sq5 + Position.FORWARD_DELTA(sd);
                    short[] sArray3 = pos.vlWhitePiecePos[2];
                    int n3 = sqBottom;
                    sArray3[n3] = (short)(sArray3[n3] + 8);
                    short[] sArray4 = pos.vlBlackPiecePos[2];
                    int n4 = sqBottom;
                    sArray4[n4] = (short)(sArray4[n4] + 8);
                }
            }
        }
        for (sq = 103; sq <= 104; ++sq) {
            if (pos.squares[sq] != 13) continue;
            short[] sArray = pos.vlWhitePiecePos[3];
            int n = sq - 16;
            sArray[n] = (short)(sArray[n] - 10);
        }
        for (sq = 23; sq <= 24; ++sq) {
            if (pos.squares[sq] != 21) continue;
            short[] sArray = pos.vlBlackPiecePos[3];
            int n = sq + 16;
            sArray[n] = (short)(sArray[n] - 10);
        }
        pos.vlBlack = 0;
        pos.vlWhite = 0;
        for (sq = 0; sq < 128; ++sq) {
            byte pc = pos.squares[sq];
            if (pc <= 0) continue;
            if (pc < 16) {
                pos.vlWhite += pos.vlWhitePiecePos[pc - 8][sq];
                continue;
            }
            pos.vlBlack += pos.vlBlackPiecePos[pc - 16][sq];
        }
    }

    public static int evaluate(Position pos, int vlAlpha, int vlBeta) {
        int vl = pos.material();
        if (vl + 100 <= vlAlpha) {
            return vl + 100;
        }
        if (vl - 100 >= vlBeta) {
            return vl - 100;
        }
        for (int sd = 0; sd < 2; ++sd) {
            int brSingle = 0;
            int brDouble = 0;
            int[] brs = sd == 0 ? pos.brWhitePawn : pos.brBlackPawn;
            for (int i = 1; i <= 6; ++i) {
                brDouble |= brSingle & brs[i];
                brSingle |= brs[i];
            }
            int brIsolated = brSingle & ~(brSingle << 1 | brSingle >> 1);
            int penalty = Util.POP_COUNT_16(brDouble) * 4 + Util.POP_COUNT_16(brIsolated) * 10 + Util.POP_COUNT_16(brIsolated & brDouble) * 10 * 2;
            vl += pos.sdPlayer == sd ? -penalty : penalty;
        }
        return vl;
    }
}

