/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class IMaidBackpack {
    public abstract ResourceLocation getId();

    public abstract Item getItem();

    public abstract void onPutOn(ItemStack var1, Player var2, EntityMaid var3);

    public ItemStack getTakeOffItemStack(ItemStack stack, @Nullable Player player, EntityMaid maid) {
        return this.getItem().getDefaultInstance();
    }

    public abstract void onTakeOff(ItemStack var1, Player var2, EntityMaid var3);

    public abstract void onSpawnTombstone(EntityMaid var1, EntityTombstone var2);

    public abstract MenuProvider getGuiProvider(int var1);

    public boolean hasBackpackData() {
        return false;
    }

    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return null;
    }

    public abstract int getAvailableMaxContainerIndex();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void offsetBackpackItem(PoseStack var1);

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityModel<EntityMaid> getBackpackModel(EntityModelSet var1);

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getBackpackTexture();

    protected final void dropAllItems(EntityMaid maid) {
        ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), 6);
    }

    protected final void dropRelativeItems(ItemStack stack, EntityMaid maid) {
        BackpackManager.findBackpack(stack).ifPresentOrElse(backpack -> {
            int startIndex = backpack.getAvailableMaxContainerIndex();
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), startIndex);
        }, () -> this.dropAllItems(maid));
    }
}

