/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSAudioToClientPackage;
import java.net.http.HttpRequest;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class TTSCallback
implements ResponseCallback<byte[]> {
    private final EntityMaid maid;
    private final String chatText;
    private final long waitingChatBubbleId;

    public TTSCallback(EntityMaid maid, String chatText, long waitingChatBubbleId) {
        this.maid = maid;
        this.chatText = chatText;
        this.waitingChatBubbleId = waitingChatBubbleId;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        Level level = this.maid.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.getServer();
            server.submit(() -> {
                LivingEntity patt0$temp = this.maid.getOwner();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    String cause = throwable.getLocalizedMessage();
                    MutableComponent errorMessage = ErrorCode.getErrorMessage(ServiceType.TTS, errorCode, cause);
                    player.sendSystemMessage((Component)errorMessage.withStyle(ChatFormatting.RED));
                }
                this.maid.getChatBubbleManager().addLLMChatText(this.chatText, this.waitingChatBubbleId);
            });
        }
        TouhouLittleMaid.LOGGER.error("LLM request failed: {}, error is {}", (Object)request, (Object)throwable.getMessage());
    }

    @Override
    public void onSuccess(byte[] data) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity owner = this.maid.getOwner();
        if (!(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)owner;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TTSAudioToClientPackage(this.maid.getId(), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.maid.getChatBubbleManager().addLLMChatText(this.chatText, this.waitingChatBubbleId);
        });
    }
}

