/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class MaidAIChatSerializable {
    public String llmSite = "";
    public String llmModel = "";
    public String ttsSite = "";
    public String ttsModel = "";
    public String ttsLanguage = "";
    public String ownerName = "";
    public String customSetting = "";

    public void decode(FriendlyByteBuf buf) {
        this.llmSite = buf.readUtf();
        this.llmModel = buf.readUtf();
        this.ttsSite = buf.readUtf();
        this.ttsModel = buf.readUtf();
        this.ttsLanguage = buf.readUtf();
        this.ownerName = buf.readUtf();
        this.customSetting = buf.readUtf();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.llmSite);
        buf.writeUtf(this.llmModel);
        buf.writeUtf(this.ttsSite);
        buf.writeUtf(this.ttsModel);
        buf.writeUtf(this.ttsLanguage);
        buf.writeUtf(this.ownerName);
        buf.writeUtf(this.customSetting);
    }

    public void copyFrom(MaidAIChatSerializable data) {
        this.llmSite = data.llmSite;
        this.llmModel = data.llmModel;
        this.ttsSite = data.ttsSite;
        this.ttsModel = data.ttsModel;
        this.ttsLanguage = data.ttsLanguage;
        this.ownerName = data.ownerName;
        this.customSetting = data.customSetting;
    }

    public CompoundTag readFromTag(CompoundTag tag) {
        if (tag.contains("MaidAIChat")) {
            CompoundTag data = tag.getCompound("MaidAIChat");
            this.llmSite = data.getString("LLMSite");
            this.llmModel = data.getString("LLMModel");
            this.ttsSite = data.getString("TTSSiteName");
            this.ttsModel = data.getString("TTSModel");
            this.ttsLanguage = data.getString("TTSLanguage");
            this.ownerName = data.getString("OwnerName");
            this.customSetting = data.getString("CustomSetting");
        }
        return tag;
    }

    public CompoundTag writeToTag(CompoundTag tag) {
        CompoundTag data = new CompoundTag();
        data.putString("LLMSite", this.llmSite);
        data.putString("LLMModel", this.llmModel);
        data.putString("TTSSiteName", this.ttsSite);
        data.putString("TTSModel", this.ttsModel);
        data.putString("TTSLanguage", this.ttsLanguage);
        data.putString("OwnerName", this.ownerName);
        data.putString("CustomSetting", this.customSetting);
        tag.put("MaidAIChat", (Tag)data);
        return tag;
    }
}

