/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.AutoGenSettingCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.ChatClientInfo;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatData;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.Player2AppCheck;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.TTSCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.papi.PapiReplacer;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.ChatType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.data.ChatTokensAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSSystemAudioToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.util.CappedQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaidAIChatManager
extends MaidAIChatData {
    public MaidAIChatManager(EntityMaid maid) {
        super(maid);
    }

    public void chat(String message, ChatClientInfo clientInfo, ServerPlayer sender) {
        if (!((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()) {
            sender.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.disable").withStyle(ChatFormatting.RED));
            return;
        }
        ChatTokensAttachment chatTokens = (ChatTokensAttachment)sender.getData(InitDataAttachment.CHAT_TOKENS);
        if (chatTokens.get() >= (Integer)AIConfig.MAX_TOKENS_PER_PLAYER.get()) {
            sender.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.ai_chat.max_tokens_limit").withStyle(ChatFormatting.RED));
            return;
        }
        @Nullable LLMSite site = this.getLLMSite();
        if (site == null || !site.enabled()) {
            sender.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.llm.empty").withStyle(ChatFormatting.RED));
            return;
        }
        if (site.id().equals(DefaultLLMSite.PLAYER2.id())) {
            Player2AppCheck.checkPlayer2App(sender, () -> this.tryToChat(message, clientInfo, site));
        } else {
            this.tryToChat(message, clientInfo, site);
        }
    }

    private void tryToChat(String message, ChatClientInfo clientInfo, @NotNull LLMSite site) {
        LLMClient chatClient = site.client();
        List<LLMMessage> chatCompletion = this.getChatCompletion(this, clientInfo.language());
        if (chatCompletion.isEmpty()) {
            this.onSettingIsEmpty(message, clientInfo, chatCompletion, chatClient);
        } else {
            this.filterConsecutiveToolMessages(chatCompletion);
            this.normalChat(message, chatCompletion, chatClient);
        }
    }

    private void filterConsecutiveToolMessages(List<LLMMessage> chatCompletion) {
        if (chatCompletion.size() <= 1) {
            return;
        }
        LLMMessage firstMessage = chatCompletion.getFirst();
        List<LLMMessage> filteredMessages = chatCompletion.stream().skip(1L).dropWhile(msg -> Role.TOOL.equals((Object)msg.role())).toList();
        chatCompletion.clear();
        chatCompletion.add(firstMessage);
        chatCompletion.addAll(filteredMessages);
    }

    private void normalChat(String message, List<LLMMessage> chatCompletion, LLMClient chatClient) {
        ChatBubbleManager bubbleManager = this.maid.getChatBubbleManager();
        chatCompletion.add(LLMMessage.userChat(this.maid, message));
        LLMConfig config = LLMConfig.normalChat(this.getLLMModel(), this.maid);
        long key = bubbleManager.addThinkingText("ai.touhou_little_maid.chat.chat_bubble_waiting");
        LLMCallback callback = new LLMCallback(this, message, key);
        chatClient.chat(chatCompletion, config, callback);
    }

    private void onSettingIsEmpty(String message, ChatClientInfo clientInfo, List<LLMMessage> chatCompletion, LLMClient chatClient) {
        ChatBubbleManager bubbleManager = this.maid.getChatBubbleManager();
        if (((Boolean)AIConfig.AUTO_GEN_SETTING_ENABLED.get()).booleanValue()) {
            LLMMessage llmMessage = this.autoGenSetting(this.maid, clientInfo);
            chatCompletion.add(llmMessage);
            LLMConfig config = new LLMConfig(this.getLLMModel(), this.maid, ChatType.AUTO_GEN_SETTING);
            MutableComponent component = Component.translatable((String)"ai.touhou_little_maid.chat.llm.role_no_setting_and_gen_setting");
            TextChatBubbleData bubbleData = TextChatBubbleData.create(600, (Component)component, IChatBubbleData.TYPE_2, 0);
            long key = bubbleManager.addChatBubble(bubbleData);
            AutoGenSettingCallback callback = new AutoGenSettingCallback(this, message, key);
            chatClient.chat(chatCompletion, config, callback);
        } else {
            bubbleManager.addTextChatBubble("ai.touhou_little_maid.chat.llm.role_no_setting");
        }
    }

    public void tts(TTSSite site, String chatText, String ttsText, long waitingChatBubbleId) {
        TTSClient ttsClient = site.client();
        String ttsModel = this.getTTSModel();
        String ttsLang = "en";
        String[] split = this.getTTSLanguage().split("_");
        if (split.length >= 2) {
            ttsLang = split[0];
        }
        TTSConfig config = new TTSConfig(ttsModel, ttsLang);
        if (ttsClient instanceof TTSSystemServices) {
            TTSSystemServices services = (TTSSystemServices)((Object)ttsClient);
            this.onPlaySoundLocal(site.id(), chatText, ttsText, config, services, waitingChatBubbleId);
        } else {
            TTSCallback callback = new TTSCallback(this.maid, chatText, waitingChatBubbleId);
            ttsClient.play(ttsText, config, callback);
        }
    }

    private List<LLMMessage> getChatCompletion(MaidAIChatManager chatManager, String language) {
        if (StringUtils.isNotBlank((CharSequence)chatManager.customSetting)) {
            EntityMaid maid = chatManager.getMaid();
            String setting = PapiReplacer.replace(chatManager.customSetting, maid, language);
            CappedQueue<LLMMessage> history = chatManager.getHistory();
            ArrayList chatList = Lists.newArrayList();
            chatList.add(LLMMessage.systemChat(maid, setting));
            history.getDeque().descendingIterator().forEachRemaining(chatList::add);
            return chatList;
        }
        return chatManager.getSetting().map(s -> {
            EntityMaid maid = chatManager.getMaid();
            String setting = s.getSetting(maid, language);
            CappedQueue<LLMMessage> history = chatManager.getHistory();
            ArrayList chatList = Lists.newArrayList();
            chatList.add(LLMMessage.systemChat(maid, setting));
            history.getDeque().descendingIterator().forEachRemaining(chatList::add);
            return chatList;
        }).orElse(Lists.newArrayList());
    }

    private LLMMessage autoGenSetting(EntityMaid maid, ChatClientInfo clientInfo) {
        HashMap valueMap = Maps.newHashMap();
        valueMap.put("model_name", clientInfo.name());
        valueMap.put("chat_language", clientInfo.language());
        Object setting = new StrSubstitutor((Map)valueMap).replace("You need to generate a character profile text based on the provided name, including the following content:\n- Character setting\n- Personality traits\n- Language style\n- Background story\n- Appearance features\n\n## Notes\n- This setting needs to be suitable for use in the game Minecraft, so it should fit Minecraft content\n- The character name may come from characters in games, anime, or manga, please follow the relevant settings as much as possible\n\n## Output Format Requirements\n- About 300 words\n- Please divide into paragraphs, separated by blank lines\n- Needs to be in ${chat_language} language\n\nCharacter: ${model_name}\n");
        if (!clientInfo.description().isEmpty()) {
            String join = StringUtils.join(clientInfo.description(), (String)"\n");
            valueMap.put("model_desc", join);
            String desc = new StrSubstitutor((Map)valueMap).replace("Character Description Section: ${model_desc}\n");
            setting = (String)setting + desc;
        }
        return LLMMessage.userChat(maid, (String)setting);
    }

    private void onPlaySoundLocal(String name, String chatText, String ttsText, TTSConfig config, TTSSystemServices services, long waitingChatBubbleId) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            LivingEntity patt0$temp = this.maid.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                TTSSystemAudioToClientPackage message = new TTSSystemAudioToClientPackage(name, ttsText, config, services);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.maid.getChatBubbleManager().addLLMChatText(chatText, waitingChatBubbleId);
        });
    }
}

