/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.manager;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelRegisterEvent;
import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

@EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BedrockEntityModelRegister<T extends AbstractBedrockEntityModel<? extends Entity>> {
    public static BedrockEntityModelRegister INSTANCE = null;
    private final BedrockEntityModelSet<T> modelSet;

    private BedrockEntityModelRegister(BedrockEntityModelSet<T> modelSet) {
        this.modelSet = modelSet;
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListenersEvent(RegisterClientReloadListenersEvent event) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager manager = (ReloadableResourceManager)resourceManager;
            INSTANCE = new BedrockEntityModelRegister(new BedrockEntityModelSet());
            ModLoader.postEvent(new BedrockEntityModelRegisterEvent(BedrockEntityModelRegister.INSTANCE.modelSet));
            BedrockEntityModelRegister.INSTANCE.modelSet.immutableKnowLocations();
            manager.listeners.addFirst(BedrockEntityModelRegister.INSTANCE.modelSet);
        }
    }

    public AbstractBedrockEntityModel<? extends Entity> getModel(ResourceLocation location) {
        return this.modelSet.getModels().get(location);
    }

    public Set<ResourceLocation> getAllModelKeys() {
        return this.modelSet.getModels().keySet();
    }
}

