/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block.transmitter;

import com.jerry.mekextras.common.tier.transmitter.CTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityUniversalCable;
import java.util.List;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.tier.CableTier;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockUniversalCable
extends ItemBlockTooltip<BlockSmallTransmitter<ExtraTileEntityUniversalCable>> {
    public ExtraItemBlockUniversalCable(BlockSmallTransmitter<ExtraTileEntityUniversalCable> block, Item.Properties properties) {
        super(block, true, properties);
    }

    @NotNull
    public CableTier getTier() {
        return Objects.requireNonNull((CableTier)Attribute.getTier((Block)this.getBlock(), CableTier.class));
    }

    protected void addDetails(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addDetails(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.CAPABLE_OF_TRANSFERRING.translateColored(EnumColor.DARK_GRAY));
        tooltip.add((Component)MekanismLang.GENERIC_TRANSFER.translateColored(EnumColor.PURPLE, new Object[]{MekanismLang.ENERGY_FORGE_SHORT, MekanismLang.FORGE}));
        tooltip.add((Component)MekanismLang.GENERIC_TRANSFER.translateColored(EnumColor.PURPLE, new Object[]{MekanismLang.ENERGY_JOULES_PLURAL, MekanismLang.MEKANISM}));
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        CableTier tier = this.getTier();
        tooltip.add((Component)MekanismLang.CAPACITY_PER_TICK.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, EnergyDisplay.of((long)CTier.getCapacityAsLong(tier))}));
    }
}

