/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item;

import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import mekanism.api.IAlloyInteraction;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.AlloyUpgradeTrigger;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;

public class ItemAlloyRadiance
extends Item {
    public ItemAlloyRadiance(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world;
        IAlloyInteraction alloyInteraction;
        Player player = context.getPlayer();
        if (player != null && MekanismConfig.general.transmitterAlloyUpgrade.get() && (alloyInteraction = (IAlloyInteraction)WorldUtils.getCapability((Level)(world = context.getLevel()), (BlockCapability)Capabilities.ALLOY_INTERACTION, (BlockPos)(pos = context.getClickedPos()), (Object)context.getClickedFace())) != null && world.getBlockEntity(pos) instanceof TileEntityTransmitter) {
            if (!world.isClientSide) {
                this.onExtraAlloyInteraction(player, context.getItemInHand(), world, pos, (TileEntityTransmitter)world.getBlockEntity(pos));
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void onExtraAlloyInteraction(Player player, ItemStack stack, Level level, BlockPos worldPosition, TileEntityTransmitter tileEntityTransmitter) {
        if (level != null && tileEntityTransmitter.getTransmitter().hasTransmitterNetwork()) {
            DynamicNetwork transmitterNetwork = tileEntityTransmitter.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(transmitterNetwork.getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getBlockPos().distSqr((Vec3i)worldPosition), o2.getBlockPos().distSqr((Vec3i)worldPosition));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                Holder<Block> target;
                BlockState upgradeState;
                TileEntityTransmitter transmitterTile;
                BlockState state;
                IUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IUpgradeableTransmitter) || (upgradeableTransmitter = (IUpgradeableTransmitter)transmitter).getTier().getBaseTier() != BaseTier.ULTIMATE || (state = (transmitterTile = transmitter.getTransmitterTile()).getBlockState()) == (upgradeState = BlockStateHelper.copyStateData((BlockState)state, target = ItemAlloyRadiance.getiBlockProvider(transmitterTile)))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                TransmitterUpgradeData upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getBlockPos();
                Level transmitterWorld = transmitter.getLevel();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.setBlockAndUpdate(transmitterPos, upgradeState);
                ExtraTileEntityTransmitter upgradedTile = (ExtraTileEntityTransmitter)WorldUtils.getTileEntity(ExtraTileEntityTransmitter.class, (BlockGetter)transmitterWorld, (BlockPos)transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IExtraUpgradeableTransmitter) {
                    this.transferUpgradeData((IExtraUpgradeableTransmitter)upgradedTransmitter, upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                transmitterNetwork.invalidate(null);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((AlloyUpgradeTrigger)MekanismCriteriaTriggers.ALLOY_UPGRADE.value()).trigger(serverPlayer);
                }
            }
        }
    }

    private static Holder<Block> getiBlockProvider(TileEntityTransmitter transmitterTile) {
        TileEntityTransmitter tileEntityTransmitter = transmitterTile;
        Objects.requireNonNull(tileEntityTransmitter);
        TileEntityTransmitter tileEntityTransmitter2 = tileEntityTransmitter;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TileEntityPressurizedTube.class, TileEntityUniversalCable.class, TileEntityMechanicalPipe.class, TileEntityThermodynamicConductor.class, TileEntityLogisticalTransporter.class}, (Object)tileEntityTransmitter2, n)) {
            case 0 -> {
                TileEntityPressurizedTube ignored = (TileEntityPressurizedTube)tileEntityTransmitter2;
                yield ExtraBlocks.ABSOLUTE_PRESSURIZED_TUBE;
            }
            case 1 -> {
                TileEntityUniversalCable ignored = (TileEntityUniversalCable)tileEntityTransmitter2;
                yield ExtraBlocks.ABSOLUTE_UNIVERSAL_CABLE;
            }
            case 2 -> {
                TileEntityMechanicalPipe ignored = (TileEntityMechanicalPipe)tileEntityTransmitter2;
                yield ExtraBlocks.ABSOLUTE_MECHANICAL_PIPE;
            }
            case 3 -> {
                TileEntityThermodynamicConductor ignored = (TileEntityThermodynamicConductor)tileEntityTransmitter2;
                yield ExtraBlocks.ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
            }
            case 4 -> {
                TileEntityLogisticalTransporter ignored = (TileEntityLogisticalTransporter)tileEntityTransmitter2;
                yield ExtraBlocks.ABSOLUTE_LOGISTICAL_TRANSPORTER;
            }
            default -> null;
        };
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IExtraUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }
}

