/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.block.basic;

import com.jerry.mekextras.common.tile.ExtraTileEntityFluidTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ExtraBlockFluidTank
extends BlockTile.BlockTileModel<ExtraTileEntityFluidTank, Machine<ExtraTileEntityFluidTank>> {
    public ExtraBlockFluidTank(Machine<ExtraTileEntityFluidTank> type) {
        super(type, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()));
    }

    public int getLightEmission(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        FluidStack fluid;
        int ambientLight = super.getLightEmission(state, world, pos);
        if (ambientLight == 15) {
            return ambientLight;
        }
        ExtraTileEntityFluidTank tile = (ExtraTileEntityFluidTank)WorldUtils.getTileEntity(ExtraTileEntityFluidTank.class, (BlockGetter)world, (BlockPos)pos);
        if (tile != null && !(fluid = tile.fluidTank.getFluid()).isEmpty()) {
            ambientLight = Math.max(ambientLight, fluid.getFluidType().getLightLevel(fluid));
        }
        return ambientLight;
    }

    @Deprecated
    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ExtraTileEntityFluidTank tile = (ExtraTileEntityFluidTank)WorldUtils.getTileEntity(ExtraTileEntityFluidTank.class, (BlockGetter)world, (BlockPos)pos, (boolean)true);
        if (tile == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (world.isClientSide) {
            return this.genericClientActivated(stack, (BlockEntity)tile);
        }
        ItemInteractionResult wrenchResult = tile.tryWrench(state, player, stack).getInteractionResult();
        if (wrenchResult.result() != InteractionResult.PASS) {
            return wrenchResult;
        }
        if (!player.isShiftKeyDown()) {
            if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, (BlockEntity)tile)) {
                return ItemInteractionResult.FAIL;
            }
            if (FluidUtils.handleTankInteraction((Player)player, (InteractionHand)hand, (ItemStack)stack, (IExtendedFluidTank)tile.fluidTank)) {
                player.getInventory().setChanged();
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

