/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.client.model.tools;

import com.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (entity.yBodyRot != entity.yBodyRotO && Mth.abs((float)this.yawVariation) < maxAngle) {
            this.yawVariation += (entity.yBodyRotO - entity.yBodyRot) / divisor;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (entity.getXRot() != entity.xRotO && Mth.abs((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += (entity.xRotO - entity.getXRot()) / divisor;
        }
        if (this.pitchVariation > 0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (Mth.abs((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (Mth.abs((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(ModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate(this.prevYawVariation, this.yawVariation, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) / (float)boxes.length;
        for (ModelPart box : boxes) {
            box.yRot += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(ModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate(this.prevPitchVariation, this.pitchVariation, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)) / (float)boxes.length;
        for (ModelPart box : boxes) {
            box.xRot += rotateAmount;
        }
    }
}

