/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.utils;

import com.github.yimeng261.maidspell.mixin.LivingEntityAccessor;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.slf4j.Logger;

public class TrueDamageUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float HEALTH_TOLERANCE = 0.01f;
    private static final Map<String, List<Integer>> healthIdMap = new HashMap<String, List<Integer>>();

    public static boolean dealTrueDamage(LivingEntity target, float damage, LivingEntity attacker) {
        boolean success;
        if (target == null) {
            return false;
        }
        float originalHealth = target.getHealth();
        float newHealth = Math.max(0.0f, originalHealth - damage);
        boolean bl = success = TrueDamageUtil.tryEntityDataDamage(target, newHealth) || TrueDamageUtil.tryNBTDamage(target, originalHealth, newHealth);
        if (success || newHealth <= 0.0f) {
            target.die(new DamageSource(Holder.direct((Object)new DamageType("info_damage", 0.0f)), (Entity)attacker));
        }
        return success;
    }

    public static boolean setNewHealth(LivingEntity target, float newHealth, LivingEntity attacker) {
        boolean success;
        if (target == null) {
            return false;
        }
        float originalHealth = target.getHealth();
        boolean bl = success = TrueDamageUtil.tryEntityDataDamage(target, newHealth) || TrueDamageUtil.tryNBTDamage(target, originalHealth, newHealth);
        if (newHealth <= 0.0f) {
            target.die(new DamageSource(Holder.direct((Object)new DamageType("info_damage", 0.0f)), (Entity)attacker));
            target.remove(Entity.RemovalReason.KILLED);
        }
        return success;
    }

    private static boolean tryEntityDataDamage(LivingEntity target, float newHealth) {
        try {
            LivingEntityAccessor healthDataIdAccessor = (LivingEntityAccessor)target;
            SynchedEntityData entityData = target.getEntityData();
            EntityDataAccessor<Float> dataHealthIdAccessor = healthDataIdAccessor.getDataHealthIdAccessor();
            boolean modified = false;
            try {
                entityData.set(dataHealthIdAccessor, (Object)Float.valueOf(newHealth));
                modified = true;
            }
            catch (Exception e) {
                LOGGER.debug("[TrueDamage] Failed to modify {}: {}", dataHealthIdAccessor, (Object)e.getMessage());
            }
            return modified;
        }
        catch (Exception e) {
            LOGGER.debug("[TrueDamage] EntityData damage failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean tryNBTDamage(LivingEntity target, float originalHealth, float newHealth) {
        try {
            CompoundTag nbt = new CompoundTag();
            target.saveWithoutId(nbt);
            boolean modified = false;
            if (nbt.contains("Health")) {
                nbt.putFloat("Health", newHealth);
                modified = true;
                LOGGER.debug("[TrueDamage] Modified NBT Health: {}", (Object)Float.valueOf(newHealth));
            }
            if (TrueDamageUtil.modifyFloatValuesInNBT(nbt, originalHealth, newHealth)) {
                modified = true;
            }
            if (modified) {
                target.load(nbt);
            }
            return modified;
        }
        catch (Exception e) {
            LOGGER.debug("[TrueDamage] NBT damage failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean modifyFloatValuesInNBT(CompoundTag nbt, float originalHealth, float newHealth) {
        boolean modified = false;
        for (String key : nbt.getAllKeys()) {
            if (nbt.get(key) instanceof FloatTag) {
                float value = nbt.getFloat(key);
                if (!TrueDamageUtil.isHealthMatch(value, originalHealth)) continue;
                nbt.putFloat(key, newHealth);
                modified = true;
                LOGGER.debug("[TrueDamage] Modified NBT Float {}: {}", (Object)key, (Object)Float.valueOf(newHealth));
                continue;
            }
            if (!(nbt.get(key) instanceof CompoundTag) || !TrueDamageUtil.modifyFloatValuesInNBT(nbt.getCompound(key), originalHealth, newHealth)) continue;
            modified = true;
        }
        return modified;
    }

    private static boolean isHealthMatch(float value1, float value2) {
        return Math.abs(value1 - value2) < 0.01f;
    }

    public static String getEntityDataInfo(LivingEntity entity) {
        try {
            LivingEntityAccessor healthDataIdAccessor = (LivingEntityAccessor)entity;
            SynchedEntityData entityData = entity.getEntityData();
            EntityDataAccessor<Float> dataHealthIdAccessor = healthDataIdAccessor.getDataHealthIdAccessor();
            float health = entity.getHealth();
            String className = entity.getClass().getSimpleName();
            StringBuilder sb = new StringBuilder();
            sb.append("=== EntityData Analysis for ").append(className).append(" ===\n");
            sb.append("Current Health: ").append(health).append("\n");
            sb.append("Max Health: ").append(entity.getMaxHealth()).append("\n");
            Float floatValue = (Float)entityData.get(dataHealthIdAccessor);
            sb.append("\n=== Health EntityData Float Values ===\n");
            sb.append(dataHealthIdAccessor).append(": ").append(floatValue);
            if (TrueDamageUtil.isHealthMatch(floatValue.floatValue(), health)) {
                sb.append(" <- HEALTH MATCH");
            } else if (floatValue.floatValue() > 0.0f && floatValue.floatValue() <= entity.getMaxHealth()) {
                sb.append(" <- Possible Health");
            }
            sb.append("\n");
            sb.append("\n=== NBT Health Information ===\n");
            try {
                CompoundTag nbt = new CompoundTag();
                entity.saveWithoutId(nbt);
                if (nbt.contains("Health")) {
                    sb.append("NBT Health: ").append(nbt.getFloat("Health")).append("\n");
                }
            }
            catch (Exception e) {
                sb.append("Failed to read NBT: ").append(e.getMessage()).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Failed to access entity data: " + e.getMessage();
        }
    }
}

