/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.manager;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import org.slf4j.Logger;

public class AllianceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, String> maidTeamMap = new HashMap<UUID, String>();
    private static final String TEAM_PREFIX = "maidspell_alliance_";

    public static void setMaidAlliance(EntityMaid maid, boolean allied) {
        if (maid == null || !(maid.level() instanceof ServerLevel)) {
            return;
        }
        if (maid.getOwner() == null || !(maid.getOwner() instanceof Player)) {
            return;
        }
        Player owner = (Player)maid.getOwner();
        ServerLevel level = (ServerLevel)maid.level();
        ServerScoreboard scoreboard = level.getScoreboard();
        UUID maidUUID = maid.getUUID();
        if (allied) {
            String teamName = TEAM_PREFIX + maidUUID.toString().substring(0, 8);
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setAllowFriendlyFire(false);
                team.setSeeFriendlyInvisibles(true);
            }
            try {
                scoreboard.addPlayerToTeam(maid.getName().getString(), team);
                scoreboard.addPlayerToTeam(owner.getName().getString(), team);
                maidTeamMap.put(maidUUID, teamName);
                LOGGER.debug("\u5973\u4ec6 {} \u5df2\u4e0e\u73a9\u5bb6 {} \u7ed3\u76df (\u961f\u4f0d: {})", new Object[]{maid.getName().getString(), owner.getName().getString(), teamName});
            }
            catch (Exception e) {
                LOGGER.error("\u8bbe\u7f6e\u5973\u4ec6\u7ed3\u76df\u65f6\u51fa\u9519", (Throwable)e);
            }
        } else {
            String teamName = maidTeamMap.remove(maidUUID);
            if (teamName != null) {
                try {
                    PlayerTeam team = scoreboard.getPlayerTeam(teamName);
                    if (team != null) {
                        scoreboard.removePlayerFromTeam(maid.getName().getString());
                        scoreboard.removePlayerFromTeam(owner.getName().getString());
                        maidTeamMap.remove(maidUUID);
                        scoreboard.removePlayerTeam(team);
                        LOGGER.debug("\u5973\u4ec6 {} \u5df2\u4e0e\u73a9\u5bb6 {} \u89e3\u9664\u7ed3\u76df (\u961f\u4f0d: {})", new Object[]{maid.getName().getString(), owner.getName().getString(), teamName});
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u89e3\u9664\u5973\u4ec6\u7ed3\u76df\u65f6\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    public static Map<UUID, String> getAllianceStatus() {
        return new HashMap<UUID, String>(maidTeamMap);
    }
}

