/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.damage.InfoDamageSource;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.chaosBook.ChaosBookBauble;
import com.github.yimeng261.maidspell.item.bauble.silverCercis.SilverCercisBauble;
import com.github.yimeng261.maidspell.item.bauble.soulBook.SoulBookBauble;
import com.github.yimeng261.maidspell.item.bauble.woundRimeBlade.WoundRimeBladeBauble;
import com.github.yimeng261.maidspell.mixin.CombatTrackerAccessor;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.utils.DataItem;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import oshi.util.tuples.Pair;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private static final Logger maidspell$LOGGER = LogUtils.getLogger();
    @Final
    @Shadow
    private static EntityDataAccessor<Float> DATA_HEALTH_ID;

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @Inject(method={"setHealth"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHealth(float health, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        float oldHealth = -114514.0f;
        try {
            oldHealth = entity.getHealth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldHealth == -114514.0f) {
            return;
        }
        if (oldHealth <= health) {
            this.maidspell$handelHpIncrease(entity, health, ci);
        } else {
            this.maidspell$handelHpDecrease(entity, health, ci);
        }
    }

    @Unique
    private void maidspell$handelHpIncrease(LivingEntity entity, float health, CallbackInfo ci) {
        if (WoundRimeBladeBauble.handleWoundRimeMap(entity, health)) {
            ci.cancel();
        }
    }

    @Unique
    private void maidspell$handelHpDecrease(LivingEntity entity, float health, CallbackInfo ci) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (SoulBookBauble.maidSoulBookCount.getOrDefault(player.getUUID(), 0) == 0) {
                return;
            }
            if (!this.maidspell$isCommonHurt(health, entity)) {
                ci.cancel();
                return;
            }
        }
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        float currentHealth = maid.getHealth();
        DataItem dataItem = new DataItem(maid, currentHealth - health);
        this.SliverCercisBauble_process(dataItem);
        if (!this.maidspell$isCommonHurt(health, entity)) {
            ci.cancel();
            return;
        }
        this.SoulBookBauble_process(dataItem);
        Global.baubleHurtCalcPre.forEach((item, func) -> {
            if (BaubleStateManager.hasBauble(maid, item)) {
                func.apply(dataItem);
            }
        });
        Global.baubleHurtCalcFinal.forEach((item, func) -> {
            if (BaubleStateManager.hasBauble(maid, item)) {
                func.apply(dataItem);
            }
        });
        if (dataItem.isCanceled()) {
            dataItem.setAmount(0.0f);
        }
        float finalHealth = Math.max(0.0f, currentHealth - dataItem.getAmount());
        maid.getEntityData().set(DATA_HEALTH_ID, (Object)Float.valueOf(finalHealth));
        ci.cancel();
    }

    @Unique
    private boolean maidspell$isCommonHurt(float health, LivingEntity entity) {
        float nowHealth = entity.getHealth();
        List<CombatEntry> entries = ((CombatTrackerAccessor)entity.getCombatTracker()).getEntries();
        if (entries.isEmpty()) {
            maidspell$LOGGER.debug("[MaidSpell] no combat entries found");
            return false;
        }
        maidspell$LOGGER.debug("[MaidSpell] nowHealth: {}, health: {}, last damage: {}", new Object[]{Float.valueOf(nowHealth), Float.valueOf(health), Float.valueOf(entries.get(entries.size() - 1).damage())});
        if ((double)Math.abs(entries.get(entries.size() - 1).damage() - (nowHealth - health)) > 0.1) {
            maidspell$LOGGER.debug("[MaidSpell] illegal damage!");
            return false;
        }
        return true;
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onHurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (damageSource == null) {
            maidspell$LOGGER.warn("[MaidSpell] Received null damage source for entity {}", (Object)entity.getUUID());
            return;
        }
        if (damageSource instanceof InfoDamageSource) {
            return;
        }
        if (entity instanceof Player || entity instanceof EntityMaid) {
            return;
        }
        Entity sourceEntity = damageSource.getEntity();
        Entity directEntity = damageSource.getDirectEntity();
        if (sourceEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)sourceEntity;
            ChaosBookBauble.chaosBookProcess(maid, entity);
            WoundRimeBladeBauble.updateWoundRimeMap(maid, entity, amount);
        } else if (directEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)directEntity;
            ChaosBookBauble.chaosBookProcess(maid, entity);
            WoundRimeBladeBauble.updateWoundRimeMap(maid, entity, amount);
        }
    }

    @Unique
    private void SoulBookBauble_process(DataItem dataItem) {
        EntityMaid maid = dataItem.getMaid();
        if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.SOUL_BOOK)) {
            return;
        }
        float damage = dataItem.getAmount();
        Pair<Boolean, Float> result = SoulBookBauble.damageCalc(maid, damage);
        if (!((Boolean)result.getA()).booleanValue()) {
            maidspell$LOGGER.debug("[SoulBookBauble] Damage cancelled for maid {} due to insufficient interval", (Object)maid.getUUID());
            dataItem.setCanceled(true);
            return;
        }
        dataItem.setAmount(((Float)result.getB()).floatValue());
        SoulBookBauble.lastHurtTimeMap.put(maid.getUUID(), maid.tickCount);
    }

    @Unique
    private void SliverCercisBauble_process(DataItem dataItem) {
        EntityMaid maid = dataItem.getMaid();
        if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.SLIVER_CERCIS)) {
            return;
        }
        LivingEntity target = maid.getLastAttacker();
        if (target == null) {
            return;
        }
        if (!target.isAlive()) {
            target = maid.getTarget();
        }
        SilverCercisBauble.handleSilverCercis(maid, target, dataItem);
    }
}

