/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.utils.ChunkLoadingManager;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityMaid.class}, remap=false)
public abstract class EntityMaidMixin
extends TamableAnimal {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    private boolean structureSpawn;

    protected EntityMaidMixin(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onFinalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CallbackInfoReturnable<SpawnGroupData> cir) {
        try {
            EntityMaid maid;
            BlockPos maidPos;
            if (reason == MobSpawnType.STRUCTURE && this.maidSpell$isInHiddenRetreatStructure(worldIn, maidPos = (maid = (EntityMaid)this).blockPosition())) {
                this.structureSpawn = false;
                Global.LOGGER.debug("Prevented finalizeSpawn processing for maid in hidden_retreat structure at {}", (Object)maidPos);
                cir.setReturnValue((Object)spawnDataIn);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to prevent finalizeSpawn processing for hidden_retreat maid", (Throwable)e);
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        try {
            EntityMaidMixin entityMaidMixin = this;
            if (entityMaidMixin instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entityMaidMixin;
                if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                    Global.LOGGER.debug("Maid {} does not have anchor_core, allowing removal", (Object)maid.getUUID());
                    return;
                }
                ChunkLoadingManager.enableChunkLoading(maid);
                Global.LOGGER.debug("remove called for {}", (Object)maid);
                if (maid.getHealth() <= 0.0f) {
                    return;
                }
                if (!this.maidSpell$isCallValid()) {
                    Global.LOGGER.debug("Prevented non-TLM removal of maid {} with health {} (anchor_core protection)", (Object)maid.getUUID(), (Object)Float.valueOf(maid.getHealth()));
                    ci.cancel();
                }
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to check maid removal source", (Throwable)e);
        }
    }

    @Unique
    private boolean maidSpell$isCallValid() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean callFromTouhouLittleMaidMod = false;
        for (int i = stackTrace.length - 10; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (className.endsWith("EntityMaid") || !className.toLowerCase().contains("tlm") && !className.toLowerCase().contains("maid")) continue;
            callFromTouhouLittleMaidMod = true;
            break;
        }
        return callFromTouhouLittleMaidMod;
    }

    @Unique
    private boolean maidSpell$isInHiddenRetreatStructure(ServerLevelAccessor worldIn, BlockPos pos) {
        StructureManager structureManager = worldIn.getLevel().structureManager();
        Optional hiddenRetreatStructureSet = worldIn.registryAccess().registryOrThrow(Registries.STRUCTURE).getOptional(new ResourceLocation("touhou_little_maid_spell", "hidden_retreat"));
        if (hiddenRetreatStructureSet.isPresent()) {
            StructureStart structureStart = structureManager.getStructureWithPieceAt(pos, (Structure)hiddenRetreatStructureSet.get());
            return structureStart.isValid();
        }
        return false;
    }
}

