/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.BiomeValidator;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchCacheManager;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchConfig;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.StripedLock;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureSearchEngine {
    private static final ResourceLocation HIDDEN_RETREAT_LOCATION = new ResourceLocation("touhou_little_maid_spell", "hidden_retreat");
    private static final ResourceKey<Structure> HIDDEN_RETREAT_KEY = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)HIDDEN_RETREAT_LOCATION);
    private static volatile HolderSet<Structure> cachedStructureSet = null;
    private static final Object STRUCTURE_SET_LOCK = new Object();
    private static final StripedLock STRUCTURE_CHECK_LOCK = new StripedLock(64);
    private static final ThreadPoolExecutor SEARCH_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(SearchConfig.getRecommendedThreadPoolSize(), r -> {
        Thread t = new Thread(r, "WindSeekingBell-Search-" + System.currentTimeMillis());
        t.setDaemon(true);
        t.setPriority(4);
        return t;
    });
    private final BiomeValidator biomeValidator;
    private final SearchCacheManager cacheManager;

    public StructureSearchEngine(BiomeValidator biomeValidator, SearchCacheManager cacheManager) {
        this.biomeValidator = biomeValidator;
        this.cacheManager = cacheManager;
    }

    public CompletableFuture<BlockPos> searchAsync(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level, playerPos);
        if (cacheResult.hasCache) {
            return CompletableFuture.completedFuture(cacheResult.structurePos);
        }
        String searchKey = this.cacheManager.generateSearchKey(playerPos);
        CompletableFuture<BlockPos> existingSearch = this.cacheManager.getOngoingSearch(searchKey);
        if (existingSearch != null) {
            return existingSearch;
        }
        CompletionStage searchFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.searchParallel(level, playerPos);
            }
            catch (Exception e) {
                Global.LOGGER.error("Structure search failed", (Throwable)e);
                return null;
            }
        }, SEARCH_EXECUTOR).whenComplete((result, throwable) -> this.cacheManager.removeSearch(searchKey));
        this.cacheManager.registerSearch(searchKey, (CompletableFuture<BlockPos>)searchFuture);
        return searchFuture;
    }

    private BlockPos searchParallel(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level, playerPos);
        if (cacheResult.hasCache) {
            return cacheResult.structurePos;
        }
        ChunkPos playerChunk = new ChunkPos(playerPos);
        BlockPos result = this.parallelSquareSearch(level, playerChunk);
        this.cacheManager.updateCache(level, playerPos, result);
        return result;
    }

    private BlockPos parallelSquareSearch(ServerLevel level, ChunkPos centerChunk) {
        int availableThreads = SearchConfig.getRecommendedThreadPoolSize();
        Global.LOGGER.debug("Starting parallel search with {} threads, radius: {}", (Object)availableThreads, (Object)64000);
        int maxSectorLayer = 64;
        for (int sectorLayer = 0; sectorLayer <= maxSectorLayer; ++sectorLayer) {
            BlockPos result = this.searchSectorLayerParallel(level, centerChunk, sectorLayer, availableThreads);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BlockPos searchSectorLayerParallel(ServerLevel level, ChunkPos centerChunk, int sectorLayer, int availableThreads) {
        if (sectorLayer == 0) {
            return this.searchSectorComplete(level, centerChunk, 0, 0, 0);
        }
        List<int[]> sectorCoords = this.generateSectorCoordinates(sectorLayer);
        ArrayList<CompletableFuture<BlockPos>> sectorTasks = new ArrayList<CompletableFuture<BlockPos>>();
        AtomicReference<Object> foundInLayer = new AtomicReference<Object>(null);
        AtomicBoolean layerComplete = new AtomicBoolean(false);
        int i = 0;
        while (i < sectorCoords.size()) {
            int[] coords = sectorCoords.get(i);
            int sectorIndex = i++;
            int sectorX = coords[0];
            int sectorZ = coords[1];
            CompletableFuture<BlockPos> sectorTask = CompletableFuture.supplyAsync(() -> this.searchSectorWithTermination(level, centerChunk, sectorX, sectorZ, layerComplete, sectorIndex), SEARCH_EXECUTOR);
            sectorTasks.add(sectorTask);
        }
        try {
            CompletableFuture<BlockPos> monitorTask = CompletableFuture.supplyAsync(() -> {
                try {
                    while (foundInLayer.get() == null && !this.areAllTasksCompleted(sectorTasks)) {
                        Thread.sleep(50L);
                        for (CompletableFuture task : sectorTasks) {
                            if (!task.isDone() || task.isCancelled()) continue;
                            try {
                                BlockPos result = (BlockPos)task.get();
                                if (result == null || !foundInLayer.compareAndSet(null, result)) continue;
                                layerComplete.set(true);
                                return result;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return (BlockPos)foundInLayer.get();
            });
            BlockPos result = monitorTask.get(120L, TimeUnit.SECONDS);
            if (result != null) {
                sectorTasks.forEach(task -> task.cancel(true));
            } else {
                CompletableFuture.allOf(sectorTasks.toArray(new CompletableFuture[0])).get(60L, TimeUnit.SECONDS);
            }
            return result;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            sectorTasks.forEach(task -> task.cancel(true));
            return null;
        }
    }

    private boolean areAllTasksCompleted(List<CompletableFuture<BlockPos>> tasks) {
        return tasks.stream().allMatch(CompletableFuture::isDone);
    }

    private List<int[]> generateSectorCoordinates(int layer) {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        if (layer == 0) {
            coords.add(new int[]{0, 0});
            return coords;
        }
        int x = -layer;
        while (x <= layer) {
            coords.add(new int[]{x++, layer});
        }
        int z = layer - 1;
        while (z >= -layer) {
            coords.add(new int[]{layer, z--});
        }
        x = layer - 1;
        while (x >= -layer) {
            coords.add(new int[]{x--, -layer});
        }
        z = -layer + 1;
        while (z <= layer - 1) {
            coords.add(new int[]{-layer, z++});
        }
        return coords;
    }

    private BlockPos searchSectorWithTermination(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ, AtomicBoolean layerComplete, int sectorIndex) {
        if (layerComplete.get()) {
            return null;
        }
        return this.searchSectorComplete(level, centerChunk, sectorX, sectorZ, sectorIndex);
    }

    private BlockPos searchSectorComplete(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ, int sectorIndex) {
        int sectorStartX = centerChunk.x + sectorX * 1000 - 500;
        int sectorEndX = sectorStartX + 1000 - 1;
        int sectorStartZ = centerChunk.z + sectorZ * 1000 - 500;
        int sectorEndZ = sectorStartZ + 1000 - 1;
        sectorStartX = Math.max(sectorStartX, centerChunk.x - 64000);
        sectorEndX = Math.min(sectorEndX, centerChunk.x + 64000);
        sectorStartZ = Math.max(sectorStartZ, centerChunk.z - 64000);
        sectorEndZ = Math.min(sectorEndZ, centerChunk.z + 64000);
        int sectorWidth = sectorEndX - sectorStartX + 1;
        int sectorHeight = sectorEndZ - sectorStartZ + 1;
        BitSet sectorChecked = new BitSet(sectorWidth * sectorHeight);
        ChunkPos sectorCenter = new ChunkPos((sectorStartX + sectorEndX) / 2, (sectorStartZ + sectorEndZ) / 2);
        int sectorRadius = Math.max(sectorWidth, sectorHeight) / 2;
        for (int layer = 0; layer <= sectorRadius; layer += 4) {
            BlockPos result = this.searchSectorLayer(level, sectorCenter, layer, sectorStartX, sectorEndX, sectorStartZ, sectorEndZ, sectorChecked);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BlockPos searchSectorLayer(ServerLevel level, ChunkPos sectorCenter, int layer, int minX, int maxX, int minZ, int maxZ, BitSet sectorChecked) {
        int z;
        BlockPos result;
        ChunkPos candidate;
        int x;
        if (layer == 0) {
            if (this.isInSectorBounds(sectorCenter, minX, maxX, minZ, maxZ) && !this.isSectorChunkChecked(sectorCenter, minX, minZ, sectorChecked, maxX - minX + 1)) {
                this.setSectorChunkChecked(sectorCenter, minX, minZ, sectorChecked, maxX - minX + 1);
                return this.checkPotentialCenter(level, sectorCenter);
            }
            return null;
        }
        for (x = -layer; x <= layer; x += 4) {
            candidate = new ChunkPos(sectorCenter.x + x, sectorCenter.z + layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || this.isSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = layer - 4; z >= -layer; z -= 4) {
            candidate = new ChunkPos(sectorCenter.x + layer, sectorCenter.z + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || this.isSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (x = layer - 4; x >= -layer; x -= 4) {
            candidate = new ChunkPos(sectorCenter.x + x, sectorCenter.z - layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || this.isSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = -layer + 4; z <= layer - 4; z += 4) {
            candidate = new ChunkPos(sectorCenter.x - layer, sectorCenter.z + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || this.isSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isInSectorBounds(ChunkPos pos, int minX, int maxX, int minZ, int maxZ) {
        return pos.x >= minX && pos.x <= maxX && pos.z >= minZ && pos.z <= maxZ;
    }

    private boolean isSectorChunkChecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth) {
        int x = chunk.x - sectorMinX;
        int z = chunk.z - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth) {
            return true;
        }
        int index = z * sectorWidth + x;
        return index >= 0 && index < sectorChecked.size() && sectorChecked.get(index);
    }

    private void setSectorChunkChecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth) {
        int x = chunk.x - sectorMinX;
        int z = chunk.z - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth) {
            return;
        }
        int index = z * sectorWidth + x;
        if (index >= 0 && index < sectorChecked.size()) {
            sectorChecked.set(index);
        }
    }

    private BlockPos checkPotentialCenter(ServerLevel level, ChunkPos centerChunk) {
        if (!this.biomeValidator.validateCherryGroveRegion(level, centerChunk)) {
            return null;
        }
        return this.verifyStructureExists(level, centerChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockPos verifyStructureExists(ServerLevel level, ChunkPos chunk) {
        try {
            HolderSet<Structure> structureSet = StructureSearchEngine.getOrInitStructureSet(level);
            if (structureSet == null) {
                return null;
            }
            BlockPos chunkCenter = new BlockPos(chunk.getMinBlockX() + 8, 64, chunk.getMinBlockZ() + 8);
            return STRUCTURE_CHECK_LOCK.executeWithLock(level, () -> {
                Pair result = level.getChunkSource().getGenerator().findNearestMapStructure(level, structureSet, chunkCenter, 1, false);
                return result != null ? (BlockPos)result.getFirst() : null;
            });
        }
        catch (Exception e) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                cachedStructureSet = null;
            }
            Global.LOGGER.debug("Structure verification failed, cache cleared", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HolderSet<Structure> getOrInitStructureSet(ServerLevel level) {
        if (cachedStructureSet == null) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                if (cachedStructureSet == null) {
                    try {
                        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
                        Holder.Reference structureHolder = structureRegistry.getHolderOrThrow(HIDDEN_RETREAT_KEY);
                        cachedStructureSet = HolderSet.direct((Holder[])new Holder[]{structureHolder});
                        Global.LOGGER.debug("Initialized structure set for hidden_retreat");
                    }
                    catch (Exception e) {
                        Global.LOGGER.error("Failed to initialize hidden_retreat structure set", (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return cachedStructureSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Object object = STRUCTURE_SET_LOCK;
        synchronized (object) {
            cachedStructureSet = null;
        }
    }
}

