/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biomes;

public class BiomeValidator {
    public boolean validateCherryGroveRegion(ServerLevel level, ChunkPos centerChunk) {
        ChunkPos[] edges;
        ChunkPos[] corners;
        if (!this.isCherryGroveChunk(level, centerChunk)) {
            return false;
        }
        for (ChunkPos corner : corners = new ChunkPos[]{new ChunkPos(centerChunk.x - 2, centerChunk.z - 2), new ChunkPos(centerChunk.x - 2, centerChunk.z + 2), new ChunkPos(centerChunk.x + 2, centerChunk.z - 2), new ChunkPos(centerChunk.x + 2, centerChunk.z + 2)}) {
            if (this.isCherryGroveChunk(level, corner)) continue;
            return false;
        }
        for (ChunkPos edge : edges = new ChunkPos[]{new ChunkPos(centerChunk.x - 2, centerChunk.z), new ChunkPos(centerChunk.x + 2, centerChunk.z), new ChunkPos(centerChunk.x, centerChunk.z - 2), new ChunkPos(centerChunk.x, centerChunk.z + 2)}) {
            if (this.isCherryGroveChunk(level, edge)) continue;
            return false;
        }
        return true;
    }

    public boolean isCherryGroveChunk(ServerLevel level, ChunkPos chunk) {
        try {
            int x = chunk.getMinBlockX() + 8;
            int z = chunk.getMinBlockZ() + 8;
            int y = level.getSeaLevel();
            Holder biome = level.getBiome(new BlockPos(x, y, z));
            return biome.is(Biomes.CHERRY_GROVE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean areAllCherryGrove(ServerLevel level, ChunkPos[] chunks) {
        for (ChunkPos chunk : chunks) {
            if (this.isCherryGroveChunk(level, chunk)) continue;
            return false;
        }
        return true;
    }
}

