/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;

public class OwnerClearTool
extends Item {
    public OwnerClearTool() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        if (target.level().isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof EntityMaid)) {
            return InteractionResult.PASS;
        }
        EntityMaid maid = (EntityMaid)target;
        if (!maid.isTame()) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.no_owner").withStyle(ChatFormatting.YELLOW));
            return InteractionResult.SUCCESS;
        }
        if (!player.isCreative() && !player.hasPermissions(2)) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.no_permission").withStyle(ChatFormatting.RED));
            return InteractionResult.SUCCESS;
        }
        LivingEntity owner = maid.getOwner();
        String ownerName = owner != null ? owner.getName().getString() : "Unknown";
        maid.setTame(false, true);
        maid.setOwnerUUID(null);
        maid.getNavigation().stop();
        maid.setTarget(null);
        player.sendSystemMessage((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.success", (Object[])new Object[]{maid.getName().getString(), ownerName}).withStyle(ChatFormatting.GREEN));
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.tooltip.line1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.tooltip.line2").withStyle(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.translatable((String)"item.touhou_little_maid_spell.owner_clear_tool.tooltip.line3").withStyle(ChatFormatting.GOLD));
    }
}

