/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.hairpin;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.damage.InfoDamageSource;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.mojang.logging.LogUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.slf4j.Logger;

public class HairpinBauble
implements IMaidBauble {
    public static final Logger LOGGER = LogUtils.getLogger();

    public HairpinBauble() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.tickCount % 10 == 0) {
            maid.getActiveEffects().forEach(effect -> {
                if (!((MobEffect)effect.getEffect().value()).isBeneficial()) {
                    effect.update(new MobEffectInstance(effect.getEffect(), 0, 0));
                }
            });
        }
    }

    @SubscribeEvent
    public void beforeMaidEffectAdded(MobEffectEvent.Applicable event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid && ItemsUtil.getBaubleSlotInMaid((EntityMaid)(maid = (EntityMaid)livingEntity), (IMaidBauble)this) >= 0) {
            MobEffectInstance effectInstance = event.getEffectInstance();
            int fl = maid.getFavorabilityManager().getLevel();
            if (fl >= 3 && !((MobEffect)effectInstance.getEffect().value()).isBeneficial()) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
            if (fl >= 2) {
                int duration = effectInstance.getDuration();
                if (((MobEffect)effectInstance.getEffect().value()).isBeneficial()) {
                    duration = Math.max((int)((double)duration * Config.hairpinBeneficialEffectExtension), duration + Config.hairpinMinExtensionTicks);
                    effectInstance.update(new MobEffectInstance(effectInstance.getEffect(), duration, event.getEffectInstance().getAmplifier(), event.getEffectInstance().isAmbient(), event.getEffectInstance().isVisible()));
                }
            }
        }
    }

    @SubscribeEvent
    public void afterMaidEat(MaidAfterEatEvent event) {
        EntityMaid maid = event.getMaid();
        if (ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)this) >= 0) {
            maid.getFavorabilityManager().add(Config.hairpinFavorabilityGain);
        }
    }

    static {
        Global.baubleCommonHurtCalcPre.put((Item)MaidSpellItems.HAIRPIN.get(), (event, maid) -> {
            LivingEntity owner = maid.getOwner();
            DamageSource source = event.getSource();
            if (owner == null) {
                return null;
            }
            if (source instanceof InfoDamageSource) {
                InfoDamageSource infoDamage = (InfoDamageSource)source;
                if ("hairpin_redirect".equals(infoDamage.msg_type)) {
                    return null;
                }
            }
            InfoDamageSource hairpinDamage = InfoDamageSource.create(owner.level(), "hairpin_redirect", source);
            hairpinDamage.setSourceEntity((LivingEntity)maid);
            owner.setInvulnerable(false);
            owner.invulnerableTime = 0;
            owner.hurt((DamageSource)hairpinDamage, event.getAmount());
            event.setCanceled(true);
            return null;
        });
        Global.playerHurtCalcAft.add((event, player) -> {
            DamageSource source = event.getSource();
            if (source instanceof InfoDamageSource) {
                InfoDamageSource infoDamage = (InfoDamageSource)source;
                if ("hairpin_redirect".equals(infoDamage.msg_type)) {
                    EntityMaid maid = (EntityMaid)infoDamage.sourceEntity;
                    maid.setInvulnerable(false);
                    maid.invulnerableTime = 0;
                    maid.hurt(source, event.getAmount());
                    event.setCanceled(true);
                }
            }
            return null;
        });
    }
}

