/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.enderPocket;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EnderPocketService {
    public static List<EnderPocketMaidInfo> getPlayerEnderPocketMaids(ServerPlayer player) {
        HashMap<UUID, EntityMaid> maids = Global.maidInfos.get(player.getUUID());
        if (maids == null || maids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnderPocketMaidInfo> enderPocketMaids = new ArrayList<EnderPocketMaidInfo>();
        for (EntityMaid maid : maids.values()) {
            if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ENDER_POCKET)) continue;
            enderPocketMaids.add(new EnderPocketMaidInfo(maid.getUUID(), maid.getName().getString(), maid.getId()));
        }
        return enderPocketMaids;
    }

    public static boolean openMaidInventory(ServerPlayer player, int maidEntityId) {
        Entity entity = player.level().getEntity(maidEntityId);
        if (!(entity instanceof EntityMaid)) {
            return false;
        }
        EntityMaid maid = (EntityMaid)entity;
        if (!maid.isOwnedBy((LivingEntity)player) || maid.isSleeping() || !maid.isAlive()) {
            return false;
        }
        maid.openMaidGui((Player)player, 0);
        return true;
    }

    public static class EnderPocketMaidInfo {
        public final UUID maidUUID;
        public final String maidName;
        public final int maidEntityId;
        public static final StreamCodec<ByteBuf, EnderPocketMaidInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EnderPocketMaidInfo::getMaidUUID, (StreamCodec)ByteBufCodecs.STRING_UTF8, EnderPocketMaidInfo::getMaidName, (StreamCodec)ByteBufCodecs.INT, EnderPocketMaidInfo::getMaidEntityId, EnderPocketMaidInfo::new);

        public EnderPocketMaidInfo(UUID maidUUID, String maidName, int maidEntityId) {
            this.maidUUID = maidUUID;
            this.maidName = maidName;
            this.maidEntityId = maidEntityId;
        }

        public UUID getMaidUUID() {
            return this.maidUUID;
        }

        public String getMaidName() {
            return this.maidName;
        }

        public int getMaidEntityId() {
            return this.maidEntityId;
        }
    }
}

