/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.blueNote.contianer;

import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.BlueNoteSpellManager;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class BlueNoteContainer
extends AbstractContainerMenu {
    public static final MenuType<BlueNoteContainer> TYPE = IMenuTypeExtension.create(BlueNoteContainer::createContainerClientSide);
    private final ItemStackHandler spellScrolls;
    private final ItemStack blueNoteStack;
    private final int blueNoteSlot;

    public static BlueNoteContainer createContainerClientSide(int id, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        int slot = data.readInt();
        ItemStack blueNoteStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data);
        ItemStackHandler scrollHandler = new ItemStackHandler(27);
        BlueNoteSpellManager.loadScrollsFromItem(blueNoteStack, scrollHandler);
        return new BlueNoteContainer(id, playerInventory, scrollHandler, blueNoteStack, slot);
    }

    public BlueNoteContainer(int id, Inventory playerInventory, ItemStackHandler spellScrolls, ItemStack blueNoteStack, int blueNoteSlot) {
        super(TYPE, id);
        int col;
        int row;
        this.spellScrolls = spellScrolls;
        this.blueNoteStack = blueNoteStack;
        this.blueNoteSlot = blueNoteSlot;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot((Slot)new ScrollSlot(spellScrolls, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 142));
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < 27) {
            Slot slot = (Slot)this.slots.get(slotId);
            ItemStack carriedItem = this.getCarried();
            if ((clickType == ClickType.PICKUP || clickType == ClickType.QUICK_MOVE) && button == 0) {
                if (!carriedItem.isEmpty() && ISpellContainer.isSpellContainer((ItemStack)carriedItem)) {
                    if (!slot.hasItem()) {
                        ItemStack copy = carriedItem.copy();
                        copy.setCount(1);
                        slot.set(copy);
                        slot.setChanged();
                        return;
                    }
                } else if (carriedItem.isEmpty() && slot.hasItem()) {
                    slot.set(ItemStack.EMPTY);
                    slot.setChanged();
                    return;
                }
            }
            return;
        }
        if (this.blueNoteSlot >= 0 && slotId == 27 + this.blueNoteSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack = slot.getItem();
            if (index < 27) {
                return ItemStack.EMPTY;
            }
            if (ISpellContainer.isSpellContainer((ItemStack)itemstack)) {
                for (int i = 0; i < 27; ++i) {
                    Slot targetSlot = (Slot)this.slots.get(i);
                    if (targetSlot.hasItem()) continue;
                    ItemStack copy = itemstack.copy();
                    copy.setCount(1);
                    targetSlot.set(copy);
                    targetSlot.setChanged();
                    return ItemStack.EMPTY;
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        if (this.blueNoteSlot >= 0) {
            ItemStack stack = player.getInventory().getItem(this.blueNoteSlot);
            return ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.blueNoteStack);
        }
        return true;
    }

    public ItemStackHandler getSpellScrolls() {
        return this.spellScrolls;
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.blueNoteStack.isEmpty()) {
            BlueNoteSpellManager.saveScrollsToItem(this.blueNoteStack, this.spellScrolls);
        }
    }

    private static class ScrollSlot
    extends SlotItemHandler {
        public ScrollSlot(ItemStackHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return ISpellContainer.isSpellContainer((ItemStack)stack);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

