/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.entity;

import com.github.yimeng261.maidspell.entity.MaidSpellEntities;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.sound.MaidSpellSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WindSeekingBellEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(WindSeekingBellEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private double targetX;
    private double targetY;
    private double targetZ;
    private int life;
    private boolean surviveAfterDeath;
    private double aX;
    private double aY;
    private double aZ;
    private Player player;
    private UUID playerUUID;

    public WindSeekingBellEntity(EntityType<? extends WindSeekingBellEntity> entityType, Level level) {
        super(entityType, level);
    }

    public WindSeekingBellEntity(Level level, Player player) {
        this((EntityType<? extends WindSeekingBellEntity>)((EntityType)MaidSpellEntities.WIND_SEEKING_BELL.get()), level);
        this.player = player;
        this.playerUUID = player.getUUID();
        this.setPos(player.getX(), player.getY(), player.getZ());
    }

    public void setItem(ItemStack stack) {
        if (stack.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, (Object)this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, (Object)stack.copyWithCount(1));
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM_STACK);
    }

    private Player getPlayer() {
        Level level;
        if (this.player != null && this.player.isAlive()) {
            return this.player;
        }
        if (this.playerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.player = serverLevel.getPlayerByUUID(this.playerUUID);
            return this.player;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM_STACK, (Object)this.getDefaultItem());
    }

    public void signalTo(BlockPos targetPos) {
        double d3;
        this.aX = (double)targetPos.getX() + 0.5;
        this.aY = targetPos.getY();
        this.aZ = (double)targetPos.getZ() + 0.5;
        double d0 = targetPos.getX();
        int i = targetPos.getY();
        double d1 = targetPos.getZ();
        double d2 = d0 - this.getX();
        double d4 = Math.sqrt(d2 * d2 + (d3 = d1 - this.getZ()) * d3);
        if (d4 > 12.0) {
            this.targetX = this.getX() + d2 / d4 * 12.0;
            this.targetZ = this.getZ() + d3 / d4 * 12.0;
            this.targetY = this.getY() + 20.0;
        } else {
            this.targetX = d0;
            this.targetY = i;
            this.targetZ = d1;
        }
        this.life = 0;
        this.surviveAfterDeath = true;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            double dz;
            double dx = this.targetX - this.getX();
            double distance = Math.sqrt(dx * dx + (dz = this.targetZ - this.getZ()) * dz);
            if (distance < 1.0) {
                this.playBreakSound();
                this.discard();
                return;
            }
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = this.getX() + vec3.x;
            double d2 = this.getZ() + vec3.z;
            double d3 = vec3.horizontalDistance();
            this.setXRot(WindSeekingBellEntity.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)d3) * 57.2957763671875)));
            this.setYRot(WindSeekingBellEntity.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875)));
            double d4 = this.targetX - d0;
            double d5 = this.targetZ - d2;
            float f = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)Mth.atan2((double)d5, (double)d4);
            double d6 = Mth.lerp((double)0.0025, (double)d3, (double)f);
            double d7 = vec3.y;
            if (f < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int j = this.getY() < this.targetY ? 1 : -1;
            vec3 = new Vec3(Math.cos(f1) * d6, d7 + ((double)j - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.setDeltaMovement(vec3);
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            ++this.life;
            if (this.life > 80 || hitResult.getType() != HitResult.Type.MISS) {
                this.playBreakSound();
                this.discard();
            }
        } else {
            this.spawnCherryParticles();
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    private static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    private void spawnCherryParticles() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 0.3;
                double offsetY = (this.random.nextDouble() - 0.5) * 0.3;
                double offsetZ = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.CHERRY_LEAVES, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, -0.1, 0.0);
            }
        }
    }

    private void playBreakSound() {
        ItemStack item;
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)MaidSpellSounds.WIND_SEEKING_BELL.get(), SoundSource.NEUTRAL, 0.8f, 0.8f);
        Player currentPlayer = this.getPlayer();
        if (currentPlayer != null) {
            ItemStack item2;
            currentPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 1));
            if (currentPlayer.isCreative()) {
                currentPlayer.teleportTo(this.aX, this.aY, this.aZ);
            }
            if (this.surviveAfterDeath && !currentPlayer.isCreative() && !(item2 = this.getItem()).isEmpty()) {
                ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item2);
                this.level().addFreshEntity((Entity)itemEntity);
            }
        } else if (this.surviveAfterDeath && !(item = this.getItem()).isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item);
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }

    protected boolean canHitEntity(Entity entity) {
        return entity instanceof Player && !entity.isSpectator() && entity.isAlive();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        compound.putDouble("TargetX", this.targetX);
        compound.putDouble("TargetY", this.targetY);
        compound.putDouble("TargetZ", this.targetZ);
        compound.putDouble("AX", this.aX);
        compound.putDouble("AY", this.aY);
        compound.putDouble("AZ", this.aZ);
        compound.putInt("Life", this.life);
        compound.putBoolean("SurviveAfterDeath", this.surviveAfterDeath);
        if (this.playerUUID != null) {
            compound.putUUID("PlayerUUID", this.playerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Item", 10)) {
            this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Item")).orElse(this.getDefaultItem()));
        }
        this.targetX = compound.getDouble("TargetX");
        this.targetY = compound.getDouble("TargetY");
        this.targetZ = compound.getDouble("TargetZ");
        this.aX = compound.getDouble("AX");
        this.aY = compound.getDouble("AY");
        this.aZ = compound.getDouble("AZ");
        this.life = compound.getInt("Life");
        this.surviveAfterDeath = compound.getBoolean("SurviveAfterDeath");
        if (compound.hasUUID("PlayerUUID")) {
            this.playerUUID = compound.getUUID("PlayerUUID");
        }
    }

    public boolean isPickable() {
        return false;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    private ItemStack getDefaultItem() {
        return new ItemStack((ItemLike)MaidSpellItems.WIND_SEEKING_BELL.get());
    }
}

