/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.client.renderer.entity;

import com.github.yimeng261.maidspell.entity.WindSeekingBellEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class WindSeekingBellRenderer
extends EntityRenderer<WindSeekingBellEntity> {
    private final ItemRenderer itemRenderer;

    public WindSeekingBellRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(WindSeekingBellEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float rotation = ((float)entity.tickCount + partialTicks) * 4.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.mulPose(Axis.XP.rotationDegrees(rotation * 0.5f));
        ItemStack itemStack = entity.getItem();
        if (!itemStack.isEmpty()) {
            this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(WindSeekingBellEntity entity) {
        return new ResourceLocation("minecraft", "textures/misc/white.png");
    }
}

