/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.entity.MaidSpellEntities;
import com.github.yimeng261.maidspell.event.MaidSpellEventHandler;
import com.github.yimeng261.maidspell.item.MaidSpellCreativeTab;
import com.github.yimeng261.maidspell.item.MaidSpellDataComponents;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.MaidSpellContainers;
import com.github.yimeng261.maidspell.item.bauble.spellCore.SpellEnhancementBauble;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.sound.MaidSpellSounds;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructurePieceTypes;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="touhou_little_maid_spell")
public class MaidSpellMod {
    public static final String MOD_ID = "touhou_little_maid_spell";
    public static final String MOD_NAME = "Touhou Little Maid: Spell";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Touhou Little Maid: Spell");

    public MaidSpellMod(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        modEventBus.addListener(this::setup);
        modEventBus.addListener(NetworkHandler::registerMessages);
        MaidSpellDataComponents.DATA_COMPONENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register(MaidSpellEventHandler.class);
        MaidSpellItems.register(modEventBus);
        MaidSpellCreativeTab.register(modEventBus);
        MaidSpellContainers.register(modEventBus);
        MaidSpellSounds.SOUNDS.register(modEventBus);
        MaidSpellEntities.register(modEventBus);
        MaidSpellStructures.STRUCTURE_TYPES.register(modEventBus);
        MaidSpellStructurePieceTypes.STRUCTURE_PIECE_TYPES.register(modEventBus);
        if (ModList.get().isLoaded("irons_spellbooks")) {
            modEventBus.addListener(SpellEnhancementBauble::initializeAttributes);
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (this.checkDependencies()) {
                LOGGER.info("Dependencies verified - initialization complete");
            }
        });
    }

    private boolean checkDependencies() {
        return this.checkModLoaded("touhou_little_maid");
    }

    private boolean checkModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

