/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.server;

import com.example.hudwatch.net.Net;
import com.example.hudwatch.net.S2CHudPayload;
import com.example.hudwatch.net.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class ServerHudDispatcher {
    private int tick;

    @SubscribeEvent
    public void onServerTickPre(ServerTickEvent.Pre e) {
        Metrics.startNs = System.nanoTime();
    }

    @SubscribeEvent
    public void onServerTickPost(ServerTickEvent.Post e) {
        Metrics.mspt = (float)(System.nanoTime() - Metrics.startNs) / 1000000.0f;
        ++this.tick;
        if (this.tick % 5 != 0) {
            return;
        }
        MinecraftServer srv = e.getServer();
        if (srv == null) {
            return;
        }
        for (ServerPlayer sp : srv.getPlayerList().getPlayers()) {
            ServerLevel lvl = sp.serverLevel();
            double px = sp.getX();
            double py = sp.getY();
            double pz = sp.getZ();
            double radius = 192.0;
            List players = lvl.players().stream().filter(p -> p != sp).map(p -> {
                float hp = p.getHealth();
                int hunger = p.getFoodData().getFoodLevel();
                float max = (float)(p.getAttribute(Attributes.MAX_HEALTH) != null ? p.getAttribute(Attributes.MAX_HEALTH).getValue() : 20.0);
                double atk = p.getAttribute(Attributes.ATTACK_DAMAGE) != null ? p.getAttribute(Attributes.ATTACK_DAMAGE).getValue() : 0.0;
                double def = p.getArmorValue();
                int x = (int)Math.floor(p.getX());
                int y = (int)Math.floor(p.getY());
                int z = (int)Math.floor(p.getZ());
                float dist = sp.distanceTo((Entity)p);
                return new Types.PlayerRow(p.getScoreboardName(), hp, max, hunger, atk, def, x, y, z, dist);
            }).sorted(Comparator.comparingDouble(Types.PlayerRow::dist)).limit(7L).collect(Collectors.toList());
            AABB box = new AABB(px - radius, py - radius, pz - radius, px + radius, py + radius, pz + radius);
            List mobs = lvl.getEntities((Entity)null, box, ent -> ent instanceof LivingEntity && !(ent instanceof Player)).stream().map(ent -> (LivingEntity)ent).map(le -> {
                String maid;
                float hp = le.getHealth();
                float max = (float)(le.getAttribute(Attributes.MAX_HEALTH) != null ? le.getAttribute(Attributes.MAX_HEALTH).getValue() : 20.0);
                double atk = le.getAttribute(Attributes.ATTACK_DAMAGE) != null ? le.getAttribute(Attributes.ATTACK_DAMAGE).getValue() : 0.0;
                double def = le.getAttribute(Attributes.ARMOR) != null ? le.getAttribute(Attributes.ARMOR).getValue() : 0.0;
                int x = (int)Math.floor(le.getX());
                int y = (int)Math.floor(le.getY());
                int z = (int)Math.floor(le.getZ());
                float dist = sp.distanceTo((Entity)le);
                String key = le.getType().getDescriptionId();
                String custom = le.hasCustomName() ? le.getCustomName().getString() : "";
                String regId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)le.getType()).toString();
                String display = ServerHudDispatcher.bestDisplayName(le);
                if (regId.startsWith("touhou_little_maid:") && !(maid = ServerHudDispatcher.tryMaidName(le)).isBlank()) {
                    display = maid;
                }
                byte cat = (byte)(le instanceof Monster ? 2 : (le.isAlliedTo((Entity)sp) ? 1 : 0));
                return new Types.MobRow(key, custom, regId, display, hp, max, atk, def, x, y, z, dist, cat);
            }).sorted(Comparator.comparingDouble(Types.MobRow::dist)).limit(7L).collect(Collectors.toList());
            S2CHudPayload m = new S2CHudPayload();
            m.mspt = Metrics.mspt;
            m.tps = Math.min(20.0f, 1000.0f / Math.max(1.0E-4f, Metrics.mspt));
            int viewBlocks = srv.getPlayerList().getViewDistance() * 16;
            double rAll = (double)viewBlocks * 1.5;
            AABB allBox = new AABB(px - rAll, py - rAll, pz - rAll, px + rAll, py + rAll, pz + rAll);
            m.entities = lvl.getEntities((Entity)null, allBox, e2 -> true).size();
            m.players = players;
            m.mobs = mobs;
            Net.sendToPlayer(sp, m);
        }
    }

    private static String bestDisplayName(LivingEntity le) {
        try {
            String s;
            if (le.getName() != null && (s = le.getName().getString()) != null && !s.isBlank()) {
                return s;
            }
        }
        catch (Throwable s) {
            // empty catch block
        }
        try {
            if (le.getDisplayName() != null && (s = le.getDisplayName().getString()) != null) {
                return s;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String tryMaidName(LivingEntity le) {
        String v;
        for (String m : new String[]{"getMaidName", "getModelName", "getModelId", "getMaidId", "getTexture"}) {
            v = ServerHudDispatcher.callStringMethod(le, m);
            if (v.isBlank()) continue;
            return ServerHudDispatcher.prettifyModelName(v);
        }
        for (String f : new String[]{"maidName", "modelName", "modelId", "maidId", "textureId", "texture"}) {
            v = ServerHudDispatcher.readStringField(le, f);
            if (v.isBlank()) continue;
            return ServerHudDispatcher.prettifyModelName(v);
        }
        String sync = ServerHudDispatcher.probeSynchedDataForModel(le);
        if (!sync.isBlank()) {
            return ServerHudDispatcher.prettifyModelName(sync);
        }
        try {
            CompoundTag tag = new CompoundTag();
            le.saveWithoutId(tag);
            String nbt = ServerHudDispatcher.scanNbtForModel((Tag)tag);
            if (!nbt.isBlank()) {
                return ServerHudDispatcher.prettifyModelName(nbt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String callStringMethod(Object obj, String name) {
        try {
            Method md = obj.getClass().getMethod(name, new Class[0]);
            Object r = md.invoke(obj, new Object[0]);
            return r == null ? "" : r.toString();
        }
        catch (NoSuchMethodException e) {}
        finally {
            return "";
        }
    }

    private static String readStringField(Object obj, String name) {
        try {
            Field f = obj.getClass().getDeclaredField(name);
            f.setAccessible(true);
            Object r = f.get(obj);
            return r == null ? "" : r.toString();
        }
        catch (NoSuchFieldException e) {}
        finally {
            return "";
        }
    }

    private static String probeSynchedDataForModel(LivingEntity le) {
        try {
            SynchedEntityData data = le.getEntityData();
            for (Class<?> c = le.getClass(); c != null; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    ResourceLocation rl;
                    String s;
                    Object val;
                    EntityDataAccessor acc;
                    if (!EntityDataAccessor.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    try {
                        acc = (EntityDataAccessor)f.get(null);
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                    if (acc == null) continue;
                    try {
                        val = data.get(acc);
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                    if (val instanceof String) {
                        String s2 = (String)val;
                        if (!ServerHudDispatcher.looksLikeModelName(s2)) continue;
                        return s2;
                    }
                    if (!(val instanceof ResourceLocation) || !ServerHudDispatcher.looksLikeModelName(s = (rl = (ResourceLocation)val).toString())) continue;
                    return s;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String scanNbtForModel(Tag t) {
        try {
            if (t instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)t;
                for (String k : ct.getAllKeys()) {
                    Tag v = ct.get(k);
                    if (v instanceof StringTag) {
                        StringTag st = (StringTag)v;
                        String sv = st.getAsString();
                        if (!ServerHudDispatcher.looksLikeModelName(k) && !ServerHudDispatcher.looksLikeModelName(sv)) continue;
                        return sv;
                    }
                    String r = ServerHudDispatcher.scanNbtForModel(v);
                    if (r.isBlank()) continue;
                    return r;
                }
            } else if (t instanceof ListTag) {
                ListTag lt = (ListTag)t;
                for (Tag e2 : lt) {
                    String r = ServerHudDispatcher.scanNbtForModel(e2);
                    if (r.isBlank()) continue;
                    return r;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static boolean looksLikeModelName(String sRaw) {
        if (sRaw == null) {
            return false;
        }
        String s = sRaw.toLowerCase(Locale.ROOT);
        return s.contains("model") || s.contains("maid") || s.contains("touhou") || s.contains("gecko") || s.contains("geckolib") || s.contains("skin") || s.contains("texture") || s.contains("modelpack");
    }

    private static String prettifyModelName(String raw) {
        String last;
        String[] prefixes;
        if (raw == null) {
            return "";
        }
        String s = raw.trim().replace('/', '_');
        int c = s.indexOf(58);
        if (c >= 0) {
            s = s.substring(c + 1);
        }
        for (String pre : prefixes = new String[]{"geckolib", "gecko", "tlm", "touhou_little_maid", "littlemaid", "maid", "model"}) {
            String low = s.toLowerCase(Locale.ROOT);
            if (!low.startsWith(pre)) continue;
            s = s.substring(pre.length());
            break;
        }
        s = s.replaceAll("^[\\-_\\.]+", "");
        HashSet<String> colors = new HashSet<String>(Arrays.asList("blue", "red", "white", "black", "green", "yellow", "orange", "purple", "pink", "cyan", "brown", "gray", "light_gray", "magenta", "lime"));
        String[] parts = s.split("_+");
        if (parts.length >= 2 && colors.contains(last = parts[parts.length - 1].toLowerCase(Locale.ROOT))) {
            s = String.join((CharSequence)"_", Arrays.copyOf(parts, parts.length - 1));
        }
        if (s.codePoints().anyMatch(cp -> cp > 256)) {
            return s;
        }
        if (s.contains("_")) {
            return Arrays.stream(s.split("_+")).filter(p -> !p.isEmpty()).map(ServerHudDispatcher::cap).collect(Collectors.joining(" "));
        }
        String out = s.replaceAll("([A-Z])", " $1").trim();
        return Arrays.stream(out.split("\\s+")).filter(p -> !p.isEmpty()).map(ServerHudDispatcher::cap).collect(Collectors.joining(" "));
    }

    private static String cap(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.substring(1).toLowerCase(Locale.ROOT) : "");
    }

    private static class Metrics {
        static long startNs = 0L;
        static float mspt = 0.0f;

        private Metrics() {
        }
    }
}

