/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

public class ServerEntityCounter {
    private static final Map<ServerLevel, Integer> COUNT = new ConcurrentHashMap<ServerLevel, Integer>();

    @SubscribeEvent
    public void onJoin(EntityJoinLevelEvent e) {
        Level level = e.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            COUNT.merge(s, 1, Integer::sum);
        }
    }

    @SubscribeEvent
    public void onLeave(EntityLeaveLevelEvent e) {
        Level level = e.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            COUNT.merge(s, -1, Integer::sum);
        }
    }

    public static int get(ServerLevel s) {
        return Math.max(0, COUNT.getOrDefault(s, 0));
    }
}

