/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.net;

import com.example.hudwatch.HudWatchMod;
import com.example.hudwatch.net.Types;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class S2CHudPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CHudPayload> TYPE = new CustomPacketPayload.Type(HudWatchMod.id("hud"));
    public static final StreamCodec<FriendlyByteBuf, S2CHudPayload> STREAM_CODEC = StreamCodec.of(S2CHudPayload::write, S2CHudPayload::read);
    public float tps;
    public float mspt;
    public int entities;
    public List<Types.PlayerRow> players = new ArrayList<Types.PlayerRow>();
    public List<Types.MobRow> mobs = new ArrayList<Types.MobRow>();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(FriendlyByteBuf buf, S2CHudPayload msg) {
        buf.writeFloat(msg.tps);
        buf.writeFloat(msg.mspt);
        buf.writeInt(msg.entities);
        buf.writeVarInt(msg.players.size());
        for (Types.PlayerRow p : msg.players) {
            buf.writeUtf(p.name());
            buf.writeFloat(p.hp());
            buf.writeFloat(p.maxHp());
            buf.writeVarInt(p.hunger());
            buf.writeDouble(p.atk());
            buf.writeDouble(p.def());
            buf.writeInt(p.x());
            buf.writeInt(p.y());
            buf.writeInt(p.z());
            buf.writeFloat(p.dist());
        }
        buf.writeVarInt(msg.mobs.size());
        for (Types.MobRow m : msg.mobs) {
            buf.writeUtf(m.nameKey());
            buf.writeUtf(m.customName());
            buf.writeUtf(m.registryId());
            buf.writeUtf(m.displayName());
            buf.writeFloat(m.hp());
            buf.writeFloat(m.maxHp());
            buf.writeDouble(m.atk());
            buf.writeDouble(m.def());
            buf.writeInt(m.x());
            buf.writeInt(m.y());
            buf.writeInt(m.z());
            buf.writeFloat(m.dist());
            buf.writeByte(m.cat());
        }
    }

    public static S2CHudPayload read(FriendlyByteBuf buf) {
        S2CHudPayload m = new S2CHudPayload();
        m.tps = buf.readFloat();
        m.mspt = buf.readFloat();
        m.entities = buf.readInt();
        int pc = buf.readVarInt();
        for (int i = 0; i < pc; ++i) {
            m.players.add(new Types.PlayerRow(buf.readUtf(), buf.readFloat(), buf.readFloat(), buf.readVarInt(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat()));
        }
        int mc = buf.readVarInt();
        for (int i = 0; i < mc; ++i) {
            m.mobs.add(new Types.MobRow(buf.readUtf(), buf.readUtf(), buf.readUtf(), buf.readUtf(), buf.readFloat(), buf.readFloat(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat(), buf.readByte()));
        }
        return m;
    }
}

