/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;

public final class ClientConfig {
    private static final String FILE_NAME = "hudwatch-client.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DoubleValue PLAYER_X = new DoubleValue(0.62);
    public static final DoubleValue PLAYER_Y = new DoubleValue(0.03);
    public static final DoubleValue ENTITY_X = new DoubleValue(0.01);
    public static final DoubleValue ENTITY_Y = new DoubleValue(0.03);
    public static final DoubleValue SERVER_X = new DoubleValue(0.72);
    public static final DoubleValue SERVER_Y = new DoubleValue(0.72);
    public static final DoubleValue PLAYER_SCALE = new DoubleValue(1.0);
    public static final DoubleValue ENTITY_SCALE = new DoubleValue(1.0);
    public static final DoubleValue SERVER_SCALE = new DoubleValue(1.0);
    public static final IntValue PANEL_BG_COLOR = new IntValue(Integer.MIN_VALUE);
    public static final IntValue PANEL_OUTLINE_COLOR = new IntValue(-52429);
    public static final BooleanValue PLAYER_VISIBLE = new BooleanValue(true);
    public static final BooleanValue ENTITY_VISIBLE = new BooleanValue(true);
    public static final BooleanValue SERVER_VISIBLE = new BooleanValue(true);

    private static Path configFile() {
        return FMLPaths.CONFIGDIR.get().resolve(FILE_NAME);
    }

    public static void load() {
        Path file = ClientConfig.configFile();
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            Data d = (Data)GSON.fromJson((Reader)r, Data.class);
            if (d == null) {
                return;
            }
            ClientConfig.PLAYER_X.value = d.playerX;
            ClientConfig.PLAYER_Y.value = d.playerY;
            ClientConfig.ENTITY_X.value = d.entityX;
            ClientConfig.ENTITY_Y.value = d.entityY;
            ClientConfig.SERVER_X.value = d.serverX;
            ClientConfig.SERVER_Y.value = d.serverY;
            ClientConfig.PLAYER_SCALE.value = d.playerScale;
            ClientConfig.ENTITY_SCALE.value = d.entityScale;
            ClientConfig.SERVER_SCALE.value = d.serverScale;
            ClientConfig.PANEL_BG_COLOR.value = d.panelBgColor;
            ClientConfig.PANEL_OUTLINE_COLOR.value = d.panelOutlineColor;
            ClientConfig.PLAYER_VISIBLE.value = d.playerVisible;
            ClientConfig.ENTITY_VISIBLE.value = d.entityVisible;
            ClientConfig.SERVER_VISIBLE.value = d.serverVisible;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            Path file = ClientConfig.configFile();
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Data d = new Data();
            d.playerX = ClientConfig.PLAYER_X.value;
            d.playerY = ClientConfig.PLAYER_Y.value;
            d.entityX = ClientConfig.ENTITY_X.value;
            d.entityY = ClientConfig.ENTITY_Y.value;
            d.serverX = ClientConfig.SERVER_X.value;
            d.serverY = ClientConfig.SERVER_Y.value;
            d.playerScale = ClientConfig.PLAYER_SCALE.value;
            d.entityScale = ClientConfig.ENTITY_SCALE.value;
            d.serverScale = ClientConfig.SERVER_SCALE.value;
            d.panelBgColor = ClientConfig.PANEL_BG_COLOR.value;
            d.panelOutlineColor = ClientConfig.PANEL_OUTLINE_COLOR.value;
            d.playerVisible = ClientConfig.PLAYER_VISIBLE.value;
            d.entityVisible = ClientConfig.ENTITY_VISIBLE.value;
            d.serverVisible = ClientConfig.SERVER_VISIBLE.value;
            try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)d, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setPlayerPos(double x, double y) {
        ClientConfig.PLAYER_X.value = x;
        ClientConfig.PLAYER_Y.value = y;
        ClientConfig.save();
    }

    public static void setEntityPos(double x, double y) {
        ClientConfig.ENTITY_X.value = x;
        ClientConfig.ENTITY_Y.value = y;
        ClientConfig.save();
    }

    public static void setServerPos(double x, double y) {
        ClientConfig.SERVER_X.value = x;
        ClientConfig.SERVER_Y.value = y;
        ClientConfig.save();
    }

    public static void setScales(double ps, double es, double ss) {
        ClientConfig.PLAYER_SCALE.value = ClientConfig.clamp(ps);
        ClientConfig.ENTITY_SCALE.value = ClientConfig.clamp(es);
        ClientConfig.SERVER_SCALE.value = ClientConfig.clamp(ss);
        ClientConfig.save();
    }

    public static void setVisibility(boolean pv, boolean ev, boolean sv) {
        ClientConfig.PLAYER_VISIBLE.value = pv;
        ClientConfig.ENTITY_VISIBLE.value = ev;
        ClientConfig.SERVER_VISIBLE.value = sv;
        ClientConfig.save();
    }

    public static void setPanelColors(int bg, int outline) {
        ClientConfig.PANEL_BG_COLOR.value = bg;
        ClientConfig.PANEL_OUTLINE_COLOR.value = outline;
        ClientConfig.save();
    }

    private static double clamp(double v) {
        return Math.max(0.5, Math.min(2.0, v));
    }

    private ClientConfig() {
    }

    private static final class Data {
        double playerX;
        double playerY;
        double entityX;
        double entityY;
        double serverX;
        double serverY;
        double playerScale;
        double entityScale;
        double serverScale;
        int panelBgColor;
        int panelOutlineColor;
        boolean playerVisible;
        boolean entityVisible;
        boolean serverVisible;

        private Data() {
        }
    }

    public static final class DoubleValue {
        double value;

        private DoubleValue(double def) {
            this.value = def;
        }

        public double get() {
            return this.value;
        }

        public void set(double v) {
            this.value = v;
            ClientConfig.save();
        }
    }

    public static final class IntValue {
        int value;

        private IntValue(int def) {
            this.value = def;
        }

        public int get() {
            return this.value;
        }

        public void set(int v) {
            this.value = v;
            ClientConfig.save();
        }
    }

    public static final class BooleanValue {
        boolean value;

        private BooleanValue(boolean def) {
            this.value = def;
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean v) {
            this.value = v;
            ClientConfig.save();
        }
    }
}

