/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.client;

import com.example.hudwatch.config.ClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ResizeScreen
extends Screen {
    private EditBox p;
    private EditBox e;
    private EditBox s;
    private EditBox bg;
    private EditBox outline;
    private boolean pv;
    private boolean ev;
    private boolean sv;
    private Button bp;
    private Button be;
    private Button bs;

    public ResizeScreen() {
        super((Component)Component.literal((String)"HUD Settings"));
    }

    protected void init() {
        int w = this.width;
        int h = this.height;
        int cx = w / 2;
        int y = h / 2 - 90;
        this.pv = ClientConfig.PLAYER_VISIBLE.get();
        this.ev = ClientConfig.ENTITY_VISIBLE.get();
        this.sv = ClientConfig.SERVER_VISIBLE.get();
        this.p = new EditBox(this.font, cx - 100, y, 200, 20, (Component)Component.literal((String)"player scale"));
        this.e = new EditBox(this.font, cx - 100, y + 24, 200, 20, (Component)Component.literal((String)"entity scale"));
        this.s = new EditBox(this.font, cx - 100, y + 48, 200, 20, (Component)Component.literal((String)"server scale"));
        this.p.setValue(String.valueOf(ClientConfig.PLAYER_SCALE.get()));
        this.e.setValue(String.valueOf(ClientConfig.ENTITY_SCALE.get()));
        this.s.setValue(String.valueOf(ClientConfig.SERVER_SCALE.get()));
        this.p.setFilter(str -> str.isEmpty() || str.matches("[-+]?\\d*(\\.\\d*)?"));
        this.e.setFilter(str -> str.isEmpty() || str.matches("[-+]?\\d*(\\.\\d*)?"));
        this.s.setFilter(str -> str.isEmpty() || str.matches("[-+]?\\d*(\\.\\d*)?"));
        this.bg = new EditBox(this.font, cx - 100, y + 92, 200, 20, (Component)Component.literal((String)"panel bg ARGB"));
        this.outline = new EditBox(this.font, cx - 100, y + 116, 200, 20, (Component)Component.literal((String)"outline ARGB"));
        this.bg.setValue(ResizeScreen.toHex(ClientConfig.PANEL_BG_COLOR.get()));
        this.outline.setValue(ResizeScreen.toHex(ClientConfig.PANEL_OUTLINE_COLOR.get()));
        this.addRenderableWidget((GuiEventListener)this.p);
        this.addRenderableWidget((GuiEventListener)this.e);
        this.addRenderableWidget((GuiEventListener)this.s);
        this.addRenderableWidget((GuiEventListener)this.bg);
        this.addRenderableWidget((GuiEventListener)this.outline);
        this.bp = Button.builder((Component)this.label("Player", this.pv), b -> {
            this.pv = !this.pv;
            this.bp.setMessage(this.label("Player", this.pv));
            this.p.active = this.pv;
        }).bounds(cx + 110, y, 90, 20).build();
        this.be = Button.builder((Component)this.label("Entity", this.ev), b -> {
            this.ev = !this.ev;
            this.be.setMessage(this.label("Entity", this.ev));
            this.e.active = this.ev;
        }).bounds(cx + 110, y + 24, 90, 20).build();
        this.bs = Button.builder((Component)this.label("Server", this.sv), b -> {
            this.sv = !this.sv;
            this.bs.setMessage(this.label("Server", this.sv));
            this.s.active = this.sv;
        }).bounds(cx + 110, y + 48, 90, 20).build();
        this.addRenderableWidget((GuiEventListener)this.bp);
        this.addRenderableWidget((GuiEventListener)this.be);
        this.addRenderableWidget((GuiEventListener)this.bs);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"OK"), b -> {
            double ps = this.pv ? ResizeScreen.parseDoubleOr(ClientConfig.PLAYER_SCALE.get(), this.p.getValue()) : ClientConfig.PLAYER_SCALE.get();
            double es = this.ev ? ResizeScreen.parseDoubleOr(ClientConfig.ENTITY_SCALE.get(), this.e.getValue()) : ClientConfig.ENTITY_SCALE.get();
            double ss = this.sv ? ResizeScreen.parseDoubleOr(ClientConfig.SERVER_SCALE.get(), this.s.getValue()) : ClientConfig.SERVER_SCALE.get();
            ClientConfig.setScales(ps, es, ss);
            int bgc = ResizeScreen.parseColorOr(ClientConfig.PANEL_BG_COLOR.get(), this.bg.getValue());
            int olc = ResizeScreen.parseColorOr(ClientConfig.PANEL_OUTLINE_COLOR.get(), this.outline.getValue());
            ClientConfig.setPanelColors(bgc, olc);
            ClientConfig.setVisibility(this.pv, this.ev, this.sv);
            this.onClose();
        }).bounds(cx - 100, y + 150, 64, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), b -> {
            this.sv = true;
            this.ev = true;
            this.pv = true;
            this.bp.setMessage(this.label("Player", this.pv));
            this.be.setMessage(this.label("Entity", this.ev));
            this.bs.setMessage(this.label("Server", this.sv));
            this.s.active = true;
            this.e.active = true;
            this.p.active = true;
            this.p.setValue("1.0");
            this.e.setValue("1.0");
            this.s.setValue("1.0");
            this.bg.setValue("80000000");
            this.outline.setValue("FFFF3333");
        }).bounds(cx - 32, y + 150, 64, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).bounds(cx + 36, y + 150, 64, 20).build());
        this.setInitialFocus((GuiEventListener)this.p);
        this.p.active = this.pv;
        this.e.active = this.ev;
        this.s.active = this.sv;
    }

    public void render(GuiGraphics g, int mx, int my, float pt) {
        this.renderBackground(g, mx, my, pt);
        super.render(g, mx, my, pt);
        int cx = this.width / 2;
        int y = this.height / 2 - 90;
        int lblX = cx - 100 - 120;
        g.drawString(this.font, "Player scale (0.5-2.0):", lblX, y + 6, -1, false);
        g.drawString(this.font, "Entity scale (0.5-2.0):", lblX, y + 30, -1, false);
        g.drawString(this.font, "Server scale (0.5-2.0):", lblX, y + 54, -1, false);
        g.drawString(this.font, "Panel BG ARGB hex:", lblX, y + 98, -5185281, false);
        g.drawString(this.font, "Outline ARGB hex:", lblX, y + 122, -5185281, false);
        int prevX = cx + 110;
        int prevY = y + 92;
        int pw = 80;
        int ph = 46;
        int bgc = ResizeScreen.parseColorOr(ClientConfig.PANEL_BG_COLOR.get(), this.bg.getValue());
        int olc = ResizeScreen.parseColorOr(ClientConfig.PANEL_OUTLINE_COLOR.get(), this.outline.getValue());
        g.fill(prevX, prevY, prevX + pw, prevY + ph, bgc);
        g.renderOutline(prevX, prevY, pw, ph, olc);
        g.drawString(this.font, "Preview", prevX + 10, prevY + ph / 2 - 4, -1, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private Component label(String name, boolean on) {
        return Component.literal((String)(name + ": " + (on ? "ON" : "OFF")));
    }

    private static double parseDoubleOr(double def, String s) {
        try {
            if (s == null || s.isBlank()) {
                return def;
            }
            return ResizeScreen.clamp(Double.parseDouble(s.trim()));
        }
        catch (Exception ignore) {
            return def;
        }
    }

    private static double clamp(double v) {
        return Math.max(0.5, Math.min(2.0, v));
    }

    private static int parseColorOr(int def, String s) {
        try {
            if (s == null || s.isBlank()) {
                return def;
            }
            String t = s.trim();
            if (t.startsWith("#")) {
                t = t.substring(1);
            }
            if (t.startsWith("0x") || t.startsWith("0X")) {
                t = t.substring(2);
            }
            long v = Long.parseUnsignedLong(t, 16);
            if (t.length() == 6) {
                v |= 0xFF000000L;
            }
            return (int)v;
        }
        catch (Exception ignore) {
            return def;
        }
    }

    private static String toHex(int argb) {
        long u = (long)argb & 0xFFFFFFFFL;
        Object s = Long.toHexString(u).toUpperCase();
        while (((String)s).length() < 8) {
            s = "0" + (String)s;
        }
        return s;
    }
}

