/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.client;

import com.example.hudwatch.client.ClientCache;
import com.example.hudwatch.client.ClientInit;
import com.example.hudwatch.client.HudPositions;
import com.example.hudwatch.client.ResizeScreen;
import com.example.hudwatch.net.Types;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="hudwatch", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class HudOverlay {
    private static final int PAD = 1;
    private static final int LINE_H = 9;
    private static final int COL_FRIEND = -528430849;
    private static final int COL_HOSTILE = -520126336;
    private static final int COL_OTHER = -520093697;
    private static final int COL_PINK = -520109850;
    private static final int COL_GREEN = -528416896;
    private static final int COL_BLUE = -536821761;
    private static final int COL_ORANGE = -520114080;
    private static final int COL_DARK_RED = -527761408;
    private static final int COL_DARK_PURPLE = -527171373;
    private static final int COL_AQUA = -522125313;
    private static final int HP_WHITE = -520093697;
    private static final int HP_YELLOW = -520093824;
    private static final int HP_ORANGE = -520114080;
    private static final int HP_RED = -520134560;
    private static boolean dragging = false;
    private static int dragBox = -1;
    private static double dragOffX;
    private static double dragOffY;
    private static Rect playerRect;
    private static Rect entityRect;
    private static Rect serverRect;

    private static int hpColor(float hp, float max) {
        if (max <= 0.0f) {
            return -520093697;
        }
        float r = hp / max;
        if (r <= 0.1f) {
            return -520134560;
        }
        if (r <= 0.25f) {
            return -520114080;
        }
        if (r <= 0.5f) {
            return -520093824;
        }
        return -520093697;
    }

    private static boolean hit(Rect r, double mx, double my) {
        return mx >= (double)r.x && mx <= (double)(r.x + r.w) && my >= (double)r.y && my <= (double)(r.y + r.h);
    }

    private static void setEditMode(boolean on) {
        HudPositions.editMode = on;
        Minecraft mc = Minecraft.getInstance();
        if (on) {
            mc.mouseHandler.releaseMouse();
        } else {
            dragging = false;
            dragBox = -1;
            mc.mouseHandler.grabMouse();
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post e) {
        if (ClientInit.EDIT != null && ClientInit.EDIT.consumeClick()) {
            HudOverlay.setEditMode(!HudPositions.editMode);
        }
        if (ClientInit.RESIZE != null && ClientInit.RESIZE.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ResizeScreen());
        }
    }

    @SubscribeEvent
    public static void onMouse(InputEvent.MouseButton.Pre e) {
        if (!HudPositions.editMode) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        if (e.getButton() == 0 && (e.getAction() == 1 || e.getAction() == 0)) {
            e.setCanceled(true);
        }
        int w = mc.getWindow().getGuiScaledWidth();
        int h = mc.getWindow().getGuiScaledHeight();
        double mx = mc.mouseHandler.xpos() * (double)w / (double)mc.getWindow().getScreenWidth();
        double my = mc.mouseHandler.ypos() * (double)h / (double)mc.getWindow().getScreenHeight();
        if (e.getAction() == 1 && e.getButton() == 0) {
            if (HudOverlay.hit(playerRect, mx, my)) {
                dragBox = 0;
            } else if (HudOverlay.hit(entityRect, mx, my)) {
                dragBox = 1;
            } else if (HudOverlay.hit(serverRect, mx, my)) {
                dragBox = 2;
            } else {
                return;
            }
            double bx = switch (dragBox) {
                case 0 -> HudPositions.playerX();
                case 1 -> HudPositions.entityX();
                default -> HudPositions.serverX();
            };
            double by = switch (dragBox) {
                case 0 -> HudPositions.playerY();
                case 1 -> HudPositions.entityY();
                default -> HudPositions.serverY();
            };
            dragOffX = mx / (double)w - bx;
            dragOffY = my / (double)h - by;
            dragging = true;
        } else if (e.getAction() == 0 && e.getButton() == 0) {
            dragging = false;
            dragBox = -1;
        }
    }

    @SubscribeEvent
    public static void onRender(RenderGuiEvent.Post e) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        GuiGraphics g = e.getGuiGraphics();
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        if (dragging && HudPositions.editMode) {
            double mx = mc.mouseHandler.xpos() * (double)sw / (double)mc.getWindow().getScreenWidth();
            double my = mc.mouseHandler.ypos() * (double)sh / (double)mc.getWindow().getScreenHeight();
            double nx = mx / (double)sw - dragOffX;
            double ny = my / (double)sh - dragOffY;
            if (dragBox == 0) {
                HudPositions.movePlayer(nx, ny);
            } else if (dragBox == 1) {
                HudPositions.moveEntity(nx, ny);
            } else {
                HudPositions.moveServer(nx, ny);
            }
        }
        HudOverlay.drawPlayers(g, sw, sh);
        HudOverlay.drawEntities(g, sw, sh);
        HudOverlay.drawServer(g, sw, sh);
    }

    private static void drawPlayers(GuiGraphics g, int sw, int sh) {
        if (!HudPositions.playerVisible()) {
            playerRect = new Rect(0, 0, 0, 0);
            return;
        }
        Font font = Minecraft.getInstance().font;
        float s = HudPositions.playerScale();
        int x = (int)((double)sw * HudPositions.playerX());
        int y = (int)((double)sh * HudPositions.playerY());
        List<Types.PlayerRow> rows = HudOverlay.getPlayers();
        ArrayList<String> lines = new ArrayList<String>(rows.size() * 2);
        for (Types.PlayerRow p : rows) {
            String left = "\u25cf " + p.name() + "  HP:";
            String hp = HudOverlay.fmt(p.hp()) + "/" + HudOverlay.fmt(p.maxHp());
            String right = "  Atk:" + HudOverlay.r1(p.atk()) + " Def:" + HudOverlay.r1(p.def());
            lines.add(left + hp + right);
            lines.add("Coord(" + p.x() + "," + p.y() + "," + p.z() + ")  Dist:" + HudOverlay.r1(p.dist()));
        }
        String header = "Player HUD" + (HudPositions.editMode ? " [Edit]" : "");
        int wPix = HudOverlay.scaledBoxWidth(font, header, lines, s);
        int hPix = HudOverlay.scaledBoxHeight(1 + lines.size(), s);
        HudOverlay.drawPanel(g, x, y, wPix, hPix, HudPositions.editMode);
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(s, s, 1.0f);
        int ty = 1;
        g.drawString(font, header, 1, ty, -1, false);
        ty += 9;
        for (int i = 0; i < rows.size(); ++i) {
            Types.PlayerRow p = rows.get(i);
            int baseCol = i % 2 == 0 ? -520101760 : -520093697;
            String left = "\u25cf " + p.name() + "  HP:";
            String hp = HudOverlay.fmt(p.hp()) + "/" + HudOverlay.fmt(p.maxHp());
            String right = "  Atk:" + HudOverlay.r1(p.atk()) + " Def:" + HudOverlay.r1(p.def());
            int dx = 1;
            g.drawString(font, left, dx, ty, baseCol, false);
            g.drawString(font, hp, dx += font.width(left), ty, HudOverlay.hpColor(p.hp(), p.maxHp()), false);
            g.drawString(font, right, dx += font.width(hp), ty, baseCol, false);
            String line2 = "Coord(" + p.x() + "," + p.y() + "," + p.z() + ")  Dist:" + HudOverlay.r1(p.dist());
            g.drawString(font, line2, 1, ty += 9, -520093697, false);
            ty += 9;
        }
        pose.popPose();
        playerRect = new Rect(x - 2, y - 2, wPix + 4, hPix + 4);
    }

    private static void drawEntities(GuiGraphics g, int sw, int sh) {
        if (!HudPositions.entityVisible()) {
            entityRect = new Rect(0, 0, 0, 0);
            return;
        }
        Font font = Minecraft.getInstance().font;
        float s = HudPositions.entityScale();
        int x = (int)((double)sw * HudPositions.entityX());
        int y = (int)((double)sh * HudPositions.entityY());
        List<Types.MobRow> rows = HudOverlay.getMobs();
        ArrayList<String> lines = new ArrayList<String>(rows.size() * 2);
        for (Types.MobRow m : rows) {
            String cust;
            String typeName = HudOverlay.localizeName(m.nameKey());
            String disp = m.displayName() == null ? "" : m.displayName();
            String string = cust = m.customName() == null ? "" : m.customName();
            String primary = !disp.isBlank() ? disp : (!cust.isBlank() ? cust : "");
            String shown = !primary.isBlank() && !primary.equals(typeName) ? primary + "\uff08" + typeName + "\uff09" : typeName;
            String left = "\u25c6 " + shown + "  HP:";
            String hp = HudOverlay.fmt(m.hp()) + "/" + HudOverlay.fmt(m.maxHp());
            String right = "  Atk:" + HudOverlay.r1(m.atk()) + " Def:" + HudOverlay.r1(m.def());
            lines.add(left + hp + right);
            lines.add("Coord(" + m.x() + "," + m.y() + "," + m.z() + ")  Dist:" + HudOverlay.r1(m.dist()));
        }
        String header = "Entity HUD" + (HudPositions.editMode ? " [Edit]" : "");
        int wPix = HudOverlay.scaledBoxWidth(font, header, lines, s);
        int hPix = HudOverlay.scaledBoxHeight(1 + lines.size(), s);
        HudOverlay.drawPanel(g, x, y, wPix, hPix, HudPositions.editMode);
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(s, s, 1.0f);
        int ty = 1;
        g.drawString(font, header, 1, ty, -1, false);
        ty += 9;
        for (Types.MobRow m : rows) {
            String cust;
            String typeName = HudOverlay.localizeName(m.nameKey());
            String disp = m.displayName() == null ? "" : m.displayName();
            String string = cust = m.customName() == null ? "" : m.customName();
            String primary = !disp.isBlank() ? disp : (!cust.isBlank() ? cust : "");
            String shown = !primary.isBlank() && !primary.equals(typeName) ? primary + "\uff08" + typeName + "\uff09" : typeName;
            String left = "\u25c6 " + shown + "  HP:";
            String hp = HudOverlay.fmt(m.hp()) + "/" + HudOverlay.fmt(m.maxHp());
            String right = "  Atk:" + HudOverlay.r1(m.atk()) + " Def:" + HudOverlay.r1(m.def());
            String modId = HudOverlay.modIdOf(m.registryId());
            int baseCol = HudOverlay.colorByMod(modId) != -1 ? HudOverlay.colorByMod(modId) : HudOverlay.colorByCat(m.cat());
            int dx = 1;
            g.drawString(font, left, dx, ty, baseCol, false);
            g.drawString(font, hp, dx += font.width(left), ty, HudOverlay.hpColor(m.hp(), m.maxHp()), false);
            g.drawString(font, right, dx += font.width(hp), ty, baseCol, false);
            String line2 = "Coord(" + m.x() + "," + m.y() + "," + m.z() + ")  Dist:" + HudOverlay.r1(m.dist());
            g.drawString(font, line2, 1, ty += 9, -520093697, false);
            ty += 9;
        }
        pose.popPose();
        entityRect = new Rect(x - 2, y - 2, wPix + 4, hPix + 4);
    }

    private static List<Types.MobRow> getMobs() {
        if (HudOverlay.freshServerData()) {
            return ClientCache.mobs;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer me = mc.player;
        if (me == null || mc.level == null) {
            return List.of();
        }
        double r = 128.0;
        AABB box = new AABB(me.getX() - r, me.getY() - r, me.getZ() - r, me.getX() + r, me.getY() + r, me.getZ() + r);
        List found = mc.level.getEntitiesOfClass(LivingEntity.class, box, le -> !(le instanceof Player));
        ArrayList<Types.MobRow> list = new ArrayList<Types.MobRow>(Math.min(found.size(), 7));
        for (LivingEntity le2 : found) {
            String ysm;
            float hp = le2.getHealth();
            float max = (float)(le2.getAttribute(Attributes.MAX_HEALTH) != null ? le2.getAttribute(Attributes.MAX_HEALTH).getValue() : 20.0);
            double atk = le2.getAttribute(Attributes.ATTACK_DAMAGE) != null ? le2.getAttribute(Attributes.ATTACK_DAMAGE).getValue() : 0.0;
            double def = le2.getAttribute(Attributes.ARMOR) != null ? le2.getAttribute(Attributes.ARMOR).getValue() : 0.0;
            int x = (int)Math.floor(le2.getX());
            int y = (int)Math.floor(le2.getY());
            int z = (int)Math.floor(le2.getZ());
            float dist = me.distanceTo((Entity)le2);
            String key = le2.getType().getDescriptionId();
            String custom = le2.hasCustomName() ? le2.getCustomName().getString() : "";
            String regId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)le2.getType()).toString();
            String display = "";
            try {
                if (le2.getName() != null) {
                    display = le2.getName().getString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (display == null || display.isBlank()) {
                try {
                    if (le2.getDisplayName() != null) {
                        display = le2.getDisplayName().getString();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!(ysm = HudOverlay.pickYsmNameFromNbt(le2)).isBlank()) {
                display = ysm;
            } else {
                String model;
                String typeNameLoc = HudOverlay.localizeName(key);
                if ((display.isBlank() || display.equals(typeNameLoc)) && !(model = HudOverlay.tryMaidNameClient(le2)).isBlank()) {
                    display = model;
                }
            }
            byte cat = (byte)(le2 instanceof Monster ? 2 : (le2.isAlliedTo((Entity)me) ? 1 : 0));
            list.add(new Types.MobRow(key, custom, regId, display, hp, max, atk, def, x, y, z, dist, cat));
        }
        list.sort(Comparator.comparingDouble(Types.MobRow::dist));
        return list.size() > 7 ? list.subList(0, 7) : list;
    }

    private static String localizeName(String keyOrName) {
        return keyOrName.startsWith("entity.") ? I18n.get((String)keyOrName, (Object[])new Object[0]) : keyOrName;
    }

    private static int colorByCat(byte cat) {
        return switch (cat) {
            case 1 -> -528430849;
            case 2 -> -520126336;
            default -> -520093697;
        };
    }

    private static String modIdOf(String registryId) {
        if (registryId == null) {
            return "minecraft";
        }
        int i = registryId.indexOf(58);
        return i > 0 ? registryId.substring(0, i) : "minecraft";
    }

    private static int colorByMod(String modId) {
        if (modId == null) {
            return -1;
        }
        if ((modId = modId.toLowerCase()).equals("twilightforest")) {
            return -528416896;
        }
        if (modId.equals("blue_skies")) {
            return -536821761;
        }
        if (modId.equals("divinerpg")) {
            return -520114080;
        }
        if (modId.equals("aoa3")) {
            return -527761408;
        }
        if (modId.equals("grimoireofgala")) {
            return -527171373;
        }
        if (modId.equals("aether")) {
            return -522125313;
        }
        if (modId.equals("touhou_little_maid") || modId.contains("littlemaid") || modId.equals("tlm")) {
            return -520109850;
        }
        return -1;
    }

    private static void drawServer(GuiGraphics g, int sw, int sh) {
        if (!HudPositions.serverVisible()) {
            serverRect = new Rect(0, 0, 0, 0);
            return;
        }
        Font font = Minecraft.getInstance().font;
        float s = HudPositions.serverScale();
        int x = (int)((double)sw * HudPositions.serverX());
        int y = (int)((double)sh * HudPositions.serverY());
        int ping = -1;
        ClientPacketListener conn = Minecraft.getInstance().getConnection();
        LocalPlayer me = Minecraft.getInstance().player;
        if (conn != null && me != null && conn.getPlayerInfo(me.getUUID()) != null) {
            ping = conn.getPlayerInfo(me.getUUID()).getLatency();
        }
        String motd = Minecraft.getInstance().getCurrentServer() != null ? Minecraft.getInstance().getCurrentServer().name : "local";
        float tps = ClientCache.tps;
        float mspt = ClientCache.mspt;
        ArrayList<String> lines = new ArrayList<String>(5);
        lines.add("MOTD: " + motd);
        lines.add((tps >= 0.0f ? String.format("TPS: %.1f", Float.valueOf(tps)) : "TPS: -") + (mspt >= 0.0f ? String.format("  MSPT: %.1f", Float.valueOf(mspt)) : "  MSPT: -"));
        lines.add("Ping: " + (String)(ping >= 0 ? ping + " ms" : "-"));
        lines.add("Entities: " + String.valueOf(ClientCache.entities >= 0 ? Integer.valueOf(ClientCache.entities) : "-"));
        lines.add("FPS: " + Minecraft.getInstance().getFps());
        String header = "Server HUD" + (HudPositions.editMode ? " [Edit]" : "");
        int wPix = HudOverlay.scaledBoxWidth(font, header, lines, s);
        int hPix = HudOverlay.scaledBoxHeight(1 + lines.size(), s);
        HudOverlay.drawPanel(g, x, y, wPix, hPix, HudPositions.editMode);
        HudOverlay.drawHeaderAndLines(g, font, x, y, header, lines, s, -1, -2031617, -2031617);
        serverRect = new Rect(x - 2, y - 2, wPix + 4, hPix + 4);
    }

    private static int scaledBoxWidth(Font font, String header, List<String> lines, float s) {
        int max = font.width(header);
        for (String l : lines) {
            max = Math.max(max, font.width(l));
        }
        return (int)Math.ceil((float)(max + 2) * s);
    }

    private static int scaledBoxHeight(int lineCount, float s) {
        return (int)Math.ceil((float)(lineCount * 9 + 2) * s);
    }

    private static void drawHeaderAndLines(GuiGraphics g, Font font, int x, int y, String header, List<String> lines, float s, int headerColor, int firstColor, int secondColor) {
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(s, s, 1.0f);
        int ty = 1;
        g.drawString(font, header, 1, ty, headerColor, false);
        ty += 9;
        for (int i = 0; i < lines.size(); ++i) {
            int col = i % 2 == 0 ? firstColor : secondColor;
            g.drawString(font, lines.get(i), 1, ty, col, false);
            ty += 9;
        }
        pose.popPose();
    }

    private static void drawPanel(GuiGraphics g, int x, int y, int w, int h, boolean edit) {
        g.fill(x - 2, y - 2, x + w + 2, y + h + 2, Integer.MIN_VALUE);
        if (edit) {
            g.renderOutline(x - 2, y - 2, w + 4, h + 4, -52429);
        }
    }

    private static String fmt(float v) {
        return v == (float)((int)v) ? Integer.toString((int)v) : String.format("%.1f", Float.valueOf(v));
    }

    private static String r1(double v) {
        return String.format("%.1f", v);
    }

    private static boolean freshServerData() {
        return System.currentTimeMillis() - ClientCache.lastUpdateMs < 2000L;
    }

    private static List<Types.PlayerRow> getPlayers() {
        if (HudOverlay.freshServerData()) {
            return ClientCache.players;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer me = mc.player;
        if (me == null || mc.level == null) {
            return List.of();
        }
        ArrayList<Types.PlayerRow> list = new ArrayList<Types.PlayerRow>();
        for (Player p : mc.level.players()) {
            if (p == me) continue;
            float hp = p.getHealth();
            int hunger = -1;
            float max = (float)(p.getAttribute(Attributes.MAX_HEALTH) != null ? p.getAttribute(Attributes.MAX_HEALTH).getValue() : 20.0);
            double atk = p.getAttribute(Attributes.ATTACK_DAMAGE) != null ? p.getAttribute(Attributes.ATTACK_DAMAGE).getValue() : 0.0;
            double def = p.getArmorValue();
            int x = (int)Math.floor(p.getX());
            int y = (int)Math.floor(p.getY());
            int z = (int)Math.floor(p.getZ());
            float dist = me.distanceTo((Entity)p);
            list.add(new Types.PlayerRow(p.getScoreboardName(), hp, max, hunger, atk, def, x, y, z, dist));
        }
        list.sort(Comparator.comparingDouble(Types.PlayerRow::dist));
        return list.size() > 7 ? list.subList(0, 7) : list;
    }

    private static String tryMaidNameClient(LivingEntity le) {
        String v;
        for (String m : new String[]{"getMaidName", "getModelName", "getModelId", "getMaidId", "getTexture"}) {
            v = HudOverlay.callStringMethod(le, m);
            if (v.isBlank()) continue;
            return HudOverlay.prettifyModelNameClient(v);
        }
        for (String f : new String[]{"maidName", "modelName", "modelId", "maidId", "textureId", "texture"}) {
            v = HudOverlay.readStringField(le, f);
            if (v.isBlank()) continue;
            return HudOverlay.prettifyModelNameClient(v);
        }
        String sync = HudOverlay.probeSynchedDataForModelClient(le);
        if (!sync.isBlank()) {
            return HudOverlay.prettifyModelNameClient(sync);
        }
        try {
            CompoundTag tag = new CompoundTag();
            le.saveWithoutId(tag);
            String nbt = HudOverlay.scanNbtForModelClient((Tag)tag);
            if (!nbt.isBlank()) {
                return HudOverlay.prettifyModelNameClient(nbt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String probeSynchedDataForModelClient(LivingEntity le) {
        try {
            SynchedEntityData data = le.getEntityData();
            for (Class<?> c = le.getClass(); c != null; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    ResourceLocation rl;
                    String s;
                    Object val;
                    EntityDataAccessor acc;
                    if (!EntityDataAccessor.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    try {
                        acc = (EntityDataAccessor)f.get(null);
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                    if (acc == null) continue;
                    try {
                        val = data.get(acc);
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                    if (val instanceof String) {
                        String s2 = (String)val;
                        if (!HudOverlay.looksLikeModelName(s2)) continue;
                        return s2;
                    }
                    if (!(val instanceof ResourceLocation) || !HudOverlay.looksLikeModelName(s = (rl = (ResourceLocation)val).toString())) continue;
                    return s;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String scanNbtForModelClient(Tag t) {
        try {
            if (t instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)t;
                for (String k : ct.getAllKeys()) {
                    Tag v = ct.get(k);
                    if (v instanceof StringTag) {
                        StringTag st = (StringTag)v;
                        String sv = st.getAsString();
                        if (!HudOverlay.looksLikeModelName(k) && !HudOverlay.looksLikeModelName(sv)) continue;
                        return sv;
                    }
                    String r = HudOverlay.scanNbtForModelClient(v);
                    if (r.isBlank()) continue;
                    return r;
                }
            } else if (t instanceof ListTag) {
                ListTag lt = (ListTag)t;
                for (Tag e : lt) {
                    String r = HudOverlay.scanNbtForModelClient(e);
                    if (r.isBlank()) continue;
                    return r;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static boolean looksLikeModelName(String sRaw) {
        if (sRaw == null) {
            return false;
        }
        String s = sRaw.toLowerCase(Locale.ROOT);
        return s.contains("model") || s.contains("maid") || s.contains("touhou") || s.contains("gecko") || s.contains("geckolib") || s.contains("skin") || s.contains("texture") || s.contains("modelpack");
    }

    private static String prettifyModelNameClient(String raw) {
        String[] parts;
        if (raw == null) {
            return "";
        }
        String s = raw.trim().replace('/', '_');
        int c = s.indexOf(58);
        if (c >= 0) {
            s = s.substring(c + 1);
        }
        String low = s.toLowerCase(Locale.ROOT);
        for (String pre : new String[]{"geckolib", "gecko", "tlm", "touhou_little_maid", "littlemaid", "maid", "model"}) {
            if (!low.startsWith(pre)) continue;
            s = s.substring(pre.length());
            break;
        }
        if ((s = s.replaceAll("(?i)([a-z]+)(fox|wolf|cat|dog|rabbit|bear|deer|horse)$", "$1 $2")).startsWith("{") && s.contains("\"text\"")) {
            try {
                Matcher m = Pattern.compile("\"text\"\\s*:\\s*\"(.*?)\"").matcher(s);
                if (m.find()) {
                    s = m.group(1);
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        if ((parts = s.split("_+")).length >= 2) {
            String last = parts[parts.length - 1].toLowerCase(Locale.ROOT);
            if (Set.of("blue", "red", "white", "black", "green", "yellow", "orange", "purple", "pink", "cyan", "brown", "gray", "light_gray", "magenta", "lime").contains(last)) {
                s = String.join((CharSequence)"_", Arrays.copyOf(parts, parts.length - 1));
            }
        }
        if (s.codePoints().anyMatch(cp -> cp > 256)) {
            return s;
        }
        if (s.contains("_")) {
            return Arrays.stream(s.split("_+")).filter(p -> !p.isEmpty()).map(HudOverlay::cap).collect(Collectors.joining(" "));
        }
        String out = s.replaceAll("([A-Z])", " $1").trim();
        return Arrays.stream(out.split("\\s+")).filter(p -> !p.isEmpty()).map(HudOverlay::cap).collect(Collectors.joining(" "));
    }

    private static String callStringMethod(Object obj, String name) {
        try {
            Method md = obj.getClass().getMethod(name, new Class[0]);
            Object r = md.invoke(obj, new Object[0]);
            return r == null ? "" : r.toString();
        }
        catch (NoSuchMethodException e) {}
        finally {
            return "";
        }
    }

    private static String readStringField(Object obj, String name) {
        try {
            Field f = obj.getClass().getDeclaredField(name);
            f.setAccessible(true);
            Object r = f.get(obj);
            return r == null ? "" : r.toString();
        }
        catch (NoSuchFieldException e) {}
        finally {
            return "";
        }
    }

    static String cap(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.substring(1).toLowerCase(Locale.ROOT) : "");
    }

    private static String pickYsmNameFromNbt(LivingEntity le) {
        try {
            CompoundTag tag = new CompoundTag();
            le.saveWithoutId(tag);
            if (tag.contains("YsmModelName", 8)) {
                return HudOverlay.prettifyModelNameClient(tag.getString("YsmModelName"));
            }
            String found = HudOverlay.findStringByKeyIgnoreCase((Tag)tag, "YsmModelName");
            if (!found.isBlank()) {
                return HudOverlay.prettifyModelNameClient(found);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static String findStringByKeyIgnoreCase(Tag t, String key) {
        try {
            if (t instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)t;
                for (String k : ct.getAllKeys()) {
                    Tag v;
                    if (k.equalsIgnoreCase(key) && (v = ct.get(k)) instanceof StringTag) {
                        StringTag st = (StringTag)v;
                        return st.getAsString();
                    }
                    String r = HudOverlay.findStringByKeyIgnoreCase(ct.get(k), key);
                    if (r.isBlank()) continue;
                    return r;
                }
            } else if (t instanceof ListTag) {
                ListTag lt = (ListTag)t;
                for (Tag e : lt) {
                    String r = HudOverlay.findStringByKeyIgnoreCase(e, key);
                    if (r.isBlank()) continue;
                    return r;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    static {
        playerRect = new Rect(0, 0, 0, 0);
        entityRect = new Rect(0, 0, 0, 0);
        serverRect = new Rect(0, 0, 0, 0);
    }

    private record Rect(int x, int y, int w, int h) {
    }
}

