/*
 * Decompiled with CFR 0.152.
 */
package com.example.hudwatch.client;

import com.example.hudwatch.client.HudPositions;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(modid="hudwatch", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class DragHandler {
    private static boolean draggingPlayer;
    private static boolean draggingEntity;
    private static boolean draggingServer;

    private DragHandler() {
    }

    @SubscribeEvent
    public static void onMouseButton(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (!HudPositions.editMode || mc.player == null || mc.level == null) {
            return;
        }
        if (mc.screen != null) {
            return;
        }
        if (event.getButton() != 0) {
            return;
        }
        event.setCanceled(true);
        if (event.getAction() == 1) {
            double[] gui = DragHandler.guiMouse();
            if (DragHandler.inPlayer(gui[0], gui[1])) {
                draggingPlayer = true;
                draggingServer = false;
                draggingEntity = false;
            } else if (DragHandler.inEntity(gui[0], gui[1])) {
                draggingEntity = true;
                draggingServer = false;
                draggingPlayer = false;
            } else if (DragHandler.inServer(gui[0], gui[1])) {
                draggingServer = true;
                draggingEntity = false;
                draggingPlayer = false;
            } else {
                draggingServer = false;
                draggingEntity = false;
                draggingPlayer = false;
            }
        } else if (event.getAction() == 0) {
            draggingServer = false;
            draggingEntity = false;
            draggingPlayer = false;
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (!HudPositions.editMode) {
            return;
        }
        if (!(draggingPlayer || draggingEntity || draggingServer)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (mc.screen != null) {
            return;
        }
        Window win = mc.getWindow();
        double[] gui = DragHandler.guiMouse();
        double nx = DragHandler.clamp01(gui[0] / (double)win.getGuiScaledWidth());
        double ny = DragHandler.clamp01(gui[1] / (double)win.getGuiScaledHeight());
        if (draggingPlayer) {
            HudPositions.movePlayer(nx, ny);
        } else if (draggingEntity) {
            HudPositions.moveEntity(nx, ny);
        } else if (draggingServer) {
            HudPositions.moveServer(nx, ny);
        }
    }

    private static double[] guiMouse() {
        Minecraft mc = Minecraft.getInstance();
        Window win = mc.getWindow();
        double gx = mc.mouseHandler.xpos() * (double)win.getGuiScaledWidth() / (double)win.getScreenWidth();
        double gy = mc.mouseHandler.ypos() * (double)win.getGuiScaledHeight() / (double)win.getScreenHeight();
        return new double[]{gx, gy};
    }

    private static boolean inPlayer(double gx, double gy) {
        return DragHandler.inBox(gx, gy, HudPositions.playerX(), HudPositions.playerY(), 320.0 * (double)HudPositions.playerScale(), 160.0 * (double)HudPositions.playerScale());
    }

    private static boolean inEntity(double gx, double gy) {
        return DragHandler.inBox(gx, gy, HudPositions.entityX(), HudPositions.entityY(), 320.0 * (double)HudPositions.entityScale(), 160.0 * (double)HudPositions.entityScale());
    }

    private static boolean inServer(double gx, double gy) {
        return DragHandler.inBox(gx, gy, HudPositions.serverX(), HudPositions.serverY(), 260.0 * (double)HudPositions.serverScale(), 120.0 * (double)HudPositions.serverScale());
    }

    private static boolean inBox(double gx, double gy, double nx, double ny, double w, double h) {
        Minecraft mc = Minecraft.getInstance();
        Window win = mc.getWindow();
        double x = nx * (double)win.getGuiScaledWidth();
        double y = ny * (double)win.getGuiScaledHeight();
        return gx >= x && gx <= x + w && gy >= y && gy <= y + h;
    }

    private static double clamp01(double v) {
        if (v < 0.0) {
            return 0.0;
        }
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }
}

