/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class ChampionHelper {
    private static final Set<BlockPos> BEACON_POS = new HashSet<BlockPos>();
    private static MinecraftServer server = null;

    public static boolean isValidChampionEntity(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            if (ChampionsConfig.allowChampionsList) {
                if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.WHITELIST) {
                    return entity.getType().is(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
                }
                if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.BLACKLIST) {
                    return !entity.getType().is(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
                }
            } else {
                return entity instanceof Enemy;
            }
        }
        return false;
    }

    public static boolean isValidChampionEntityType(EntityType<?> entityType) {
        if (ChampionsConfig.allowChampionsList) {
            if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.WHITELIST) {
                return entityType.is(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
            }
            if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.BLACKLIST) {
                return !entityType.is(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
            }
        }
        return entityType.getCategory() == MobCategory.MONSTER;
    }

    public static boolean isValidChampion(IChampion.Client client) {
        Optional<Tuple<Integer, String>> rank = client.getRank();
        return rank.isPresent() && rank.map(Tuple::getA).orElse(0) > 0 && !client.getAffixes().isEmpty();
    }

    public static boolean isValidChampion(IChampion.Server server) {
        Optional<Rank> rank = server.getRank();
        return rank.isPresent() && rank.map(Rank::getTier).orElse(-1) > 0 && !server.getAffixes().isEmpty();
    }

    public static boolean isChampionEntity(Entity entity) {
        return ChampionAttachment.getAttachment(entity).map(champion -> ChampionHelper.isValidChampion(champion.getServer())).orElse(false);
    }

    public static boolean notPotential(LivingEntity livingEntity) {
        return !ChampionHelper.isValidEntity(livingEntity) || !ChampionHelper.isValidDimension(livingEntity.level().dimension().location()) || ChampionHelper.nearActiveBeacon(livingEntity);
    }

    public static void addBeacon(BlockPos pos) {
        if (server != null) {
            BEACON_POS.add(pos);
        }
    }

    private static boolean isValidEntity(LivingEntity livingEntity) {
        ResourceLocation rl = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
        String entity = rl.toString();
        if (ChampionsConfig.entitiesPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.entitiesList.contains(entity);
        }
        return ChampionsConfig.entitiesList.contains(entity);
    }

    public static boolean areEntitiesNearby(BlockPos pos, List<LivingEntity> livingEntities, EntityType<?> entityType) {
        for (LivingEntity livingentity : livingEntities) {
            if (!livingentity.isAlive() || livingentity.isRemoved() || !pos.closerToCenterThan((Position)livingentity.position(), 32.0) || livingentity.getType() != entityType) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        String dimension = resourceLocation.toString();
        if (ChampionsConfig.dimensionPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.dimensionList.contains(dimension);
        }
        return ChampionsConfig.dimensionList.contains(dimension);
    }

    private static boolean nearActiveBeacon(LivingEntity livingEntity) {
        int range = ChampionsConfig.beaconProtectionRange;
        if (range <= 0) {
            return false;
        }
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (BlockPos pos : BEACON_POS) {
            Level level = livingEntity.level();
            if (!level.isLoaded(pos)) continue;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BeaconBlockEntity) {
                BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
                if (!blockEntity.isRemoved()) {
                    if (!(livingEntity.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)(range * range)) || beaconBlockEntity.levels <= 0) continue;
                    return true;
                }
            }
            toRemove.add(pos);
        }
        BEACON_POS.removeAll(toRemove);
        return false;
    }

    public static void clearBeacons() {
        BEACON_POS.clear();
    }

    public static void setServer(MinecraftServer serverIn) {
        server = serverIn;
    }
}

