/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModStats {
    private static final DeferredRegister<ResourceLocation> CHAMPIONS_STATS = DeferredRegister.create((Registry)BuiltInRegistries.CUSTOM_STAT, (String)"champions");
    private static final Map<ResourceLocation, StatFormatter> CUSTOM_STAT_FORMATTERS = new HashMap<ResourceLocation, StatFormatter>();
    public static final DeferredHolder<ResourceLocation, ResourceLocation> CHAMPION_MOBS_KILLED = ModStats.makeCustomStat("champion_mobs_killed", StatFormatter.DEFAULT);

    public static void register(IEventBus bus) {
        CHAMPIONS_STATS.register(bus);
    }

    private static DeferredHolder<ResourceLocation, ResourceLocation> makeCustomStat(String key, StatFormatter formatter) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)CHAMPIONS_STATS.getNamespace(), (String)key);
        DeferredHolder holder = CHAMPIONS_STATS.register(key, () -> resourceLocation);
        CUSTOM_STAT_FORMATTERS.put(resourceLocation, formatter);
        return holder;
    }

    public static void registerFormatter() {
        CUSTOM_STAT_FORMATTERS.forEach((arg_0, arg_1) -> ((StatType)Stats.CUSTOM).get(arg_0, arg_1));
    }
}

