/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.mixin;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.server.command.ChampionsCommand;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @ModifyVariable(method={"pickBlock"}, at=@At(value="STORE", target="Lnet/minecraft/world/entity/player/Inventory;setPickedItem(Lnet/minecraft/world/item/ItemStack;)V"))
    private ItemStack modifyItemStack(ItemStack original) {
        IChampion champion;
        IChampion.Client clientChampion;
        Optional<IChampion> championOptional;
        Entity pickedEntity = Minecraft.getInstance().crosshairPickEntity;
        LocalPlayer player = Minecraft.getInstance().player;
        MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
        if (pickedEntity != null && player != null && gameMode != null && (championOptional = ChampionAttachment.getAttachment(pickedEntity)).isPresent() && ChampionHelper.isValidChampion(clientChampion = (champion = championOptional.get()).getClient())) {
            EntityType type = champion.getLivingEntity().getType();
            Integer tier = clientChampion.getRank().map(Tuple::getA).orElseThrow();
            List<IAffix> affixes = clientChampion.getAffixes();
            return ChampionsCommand.createEgg(type, tier, affixes);
        }
        return original;
    }
}

