/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModLootItemConditions;

public record EntityIsChampion(Optional<Integer> minTier, Optional<Integer> maxTier, LootContext.EntityTarget target) implements LootItemCondition,
EntitySubPredicate
{
    public static final MapCodec<EntityIsChampion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("minTier").forGetter(EntityIsChampion::minTier), (App)Codec.INT.optionalFieldOf("maxTier").forGetter(EntityIsChampion::maxTier), (App)LootContext.EntityTarget.CODEC.fieldOf("entity").forGetter(EntityIsChampion::target)).apply((Applicative)instance, EntityIsChampion::new));

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)this.target.getParam());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(this.target.getParam());
        return entity != null && this.isChampion(entity);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootItemConditions.ENTITY_IS_CHAMPION.get();
    }

    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        return this.isChampion(entity);
    }

    private boolean isChampion(Entity entity) {
        return ChampionAttachment.getAttachment(entity).map(champion -> {
            int tier = champion.getServer().getRank().map(Rank::getTier).orElse(0);
            boolean aboveMin = this.minTier.map(integer -> tier >= integer).orElseGet(() -> tier >= 1);
            boolean belowMax = this.maxTier.isEmpty() || tier <= this.maxTier.get();
            return aboveMin && belowMax;
        }).orElse(false);
    }
}

