/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.item.dispense;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class DispenseHandler {
    public static ItemStack handleChampionEggDispense(BlockSource source, ItemStack stack) {
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        Optional<EntityType<?>> entityType = ChampionEggItem.getType(stack);
        entityType.ifPresent(type -> {
            Entity entity = type.create(source.level(), s -> stack.getTags(), source.pos().relative(direction), MobSpawnType.DISPENSER, true, direction != Direction.UP);
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                if (ChampionHelper.isValidChampion(champion.getServer())) {
                    ChampionEggItem.read(champion, stack);
                    source.level().addFreshEntity((Entity)champion.getLivingEntity());
                    stack.shrink(1);
                }
            });
        });
        return stack;
    }
}

