/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.registry.ModDataComponents;
import top.theillusivec4.champions.common.util.ChampionBuilder;

public class ChampionEggItem
extends EggItem {
    private static final String ID_TAG = "Id";
    private static final String ENTITY_TAG = "EntityTag";
    private static final String TIER_TAG = "Tier";
    private static final String AFFIX_TAG = "Affix";
    private static final String CHAMPION_TAG = "Champion";

    public ChampionEggItem() {
        super(new Item.Properties());
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        SpawnEggItem eggItem = SpawnEggItem.byId((EntityType)ChampionEggItem.getType(stack).orElse(EntityType.ZOMBIE));
        return eggItem != null ? FastColor.ARGB32.opaque((int)eggItem.getColor(tintIndex)) : 0;
    }

    public static Optional<EntityType<?>> getType(ItemStack stack) {
        String id;
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, ENTITY_TAG);
        if (entityTag.isPresent() && !(id = entityTag.get().getString(ID_TAG)).isEmpty()) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)id));
        }
        return Optional.empty();
    }

    public static Optional<CompoundTag> getTagOrEmpty(ItemStack stack, String tagKey) {
        CompoundTag entityTag;
        if (stack.has(ModDataComponents.ENTITY_TAG_COMPONENT) && (entityTag = (CompoundTag)stack.get(ModDataComponents.ENTITY_TAG_COMPONENT)) != null) {
            return Optional.of(entityTag.getCompound(tagKey));
        }
        return Optional.empty();
    }

    public static void read(IChampion champion, ItemStack stack) {
        Optional<CompoundTag> tag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        tag.ifPresent(entityTag -> {
            int tier = entityTag.getInt(TIER_TAG);
            ListTag affixTag = entityTag.getList(AFFIX_TAG, 8);
            ArrayList<IAffix> affixes = new ArrayList<IAffix>();
            affixTag.forEach(affix -> Champions.API.getAffix(affix.getAsString()).ifPresent(affixes::add));
            ChampionBuilder.spawnPreset(champion, tier, affixes);
        });
    }

    public static void write(ItemStack stack, ResourceLocation entityId, int tier, Collection<IAffix> affixes) {
        CompoundTag tag = (CompoundTag)stack.getOrDefault(ModDataComponents.ENTITY_TAG_COMPONENT, (Object)new CompoundTag());
        CompoundTag entityTag = new CompoundTag();
        entityTag.putString(ID_TAG, entityId.toString());
        tag.put(ENTITY_TAG, (Tag)entityTag);
        CompoundTag tierTag = new CompoundTag();
        tierTag.putInt(TIER_TAG, tier);
        ListTag listNBT = new ListTag();
        affixes.forEach(affix -> listNBT.add((Object)StringTag.valueOf((String)affix.getIdentifier().toString())));
        tierTag.put(AFFIX_TAG, (Tag)listNBT);
        tag.put(CHAMPION_TAG, (Tag)tierTag);
        stack.set(ModDataComponents.ENTITY_TAG_COMPONENT, (Object)tag);
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        int tier = 0;
        Optional<EntityType<?>> type = ChampionEggItem.getType(stack);
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        if (entityTag.isPresent()) {
            tier = entityTag.get().getInt(TIER_TAG);
        }
        MutableComponent root = Component.translatable((String)("rank.champions.title." + tier));
        root.append(" ");
        root.append(type.map(EntityType::getDescription).orElse(EntityType.ZOMBIE.getDescription()));
        root.append(" ");
        root.append(this.getDescription());
        return root;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flagIn) {
        boolean hasAffix = false;
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        if (entityTag.isPresent()) {
            ListTag affixTag = entityTag.get().getList(AFFIX_TAG, 8);
            if (!affixTag.isEmpty()) {
                hasAffix = true;
            }
            affixTag.forEach(affix -> Champions.API.getAffix(affix.getAsString()).ifPresent(affix1 -> {
                MutableComponent component = Component.translatable((String)affix1.toLanguageKey());
                component.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
                tooltip.add((Component)component);
            }));
        }
        if (!hasAffix) {
            MutableComponent component = Component.translatable((String)"item.champions.egg.tooltip");
            component.setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA));
            tooltip.add((Component)component);
        }
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide() && world instanceof ServerLevel) {
            ItemStack itemstack = context.getItemInHand();
            BlockPos blockpos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            BlockState blockstate = world.getBlockState(blockpos);
            BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
            Optional<EntityType<?>> entityType = ChampionEggItem.getType(itemstack);
            entityType.ifPresent(type -> {
                Entity entity = type.create((ServerLevel)world, null, blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(iChampion -> {
                        ChampionEggItem.read(iChampion, itemstack);
                        world.addFreshEntity(entity);
                        itemstack.shrink(1);
                    });
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (worldIn instanceof ServerLevel) {
            BlockHitResult povHitResult = ChampionEggItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (povHitResult.getType() != HitResult.Type.BLOCK) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            BlockPos blockpos = povHitResult.getBlockPos();
            if (!(worldIn.getFluidState(blockpos).getType() instanceof FlowingFluid)) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            if (worldIn.mayInteract(playerIn, blockpos) && playerIn.mayUseItemAt(blockpos, povHitResult.getDirection(), itemstack)) {
                Optional<EntityType<?>> entityType = ChampionEggItem.getType(itemstack);
                return entityType.map(type -> {
                    Entity entity = type.create((ServerLevel)worldIn, null, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                    if (entity instanceof LivingEntity) {
                        ChampionAttachment.getAttachment(entity).ifPresent(iChampion -> ChampionEggItem.read(iChampion, itemstack));
                        worldIn.addFreshEntity(entity);
                        if (!playerIn.getAbilities().invulnerable) {
                            itemstack.shrink(1);
                        }
                        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
                        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
                    }
                    return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
                }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack));
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }
}

