/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.gateways_to_eternity;

import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.event.GateEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.Gateways;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysSetting;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysSettingLoader;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class GatewaysToEternityCompat {
    private final GatewaysSettingLoader settings = new GatewaysSettingLoader();

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.settings);
    }

    @SubscribeEvent
    public void onWaveEntitySpawned(GateEvent.WaveEntitySpawned event) {
        LivingEntity waveSpawnedEntity = event.getWaveEntity();
        ResourceLocation waveSpawnedEntityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)waveSpawnedEntity.getType());
        GatewayEntity gatewayEntity = event.getEntity();
        int currentWave = gatewayEntity.getWave();
        Gateways eventGateWayEntityType = GatewaysSetting.byEntityType(gatewayEntity);
        this.settings.getLoadedData().values().stream().filter(gatewaysSetting -> gatewaysSetting.enable().orElse(false)).forEach(gatewaysSetting -> {
            Gateways gatewayTypeSetting = gatewaysSetting.gatewayType();
            List<Object> entityList = gatewaysSetting.entityBlackList().isPresent() ? gatewaysSetting.entityBlackList().get() : new ArrayList();
            MinMaxBounds.Ints waveRange = gatewaysSetting.waveRange();
            if (!gatewaysSetting.enable().orElse(false).booleanValue() || eventGateWayEntityType != gatewayTypeSetting || !waveRange.matches(currentWave) || entityList.contains(waveSpawnedEntityId)) {
                return;
            }
            ChampionAttachment.getAttachment((Entity)waveSpawnedEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    ChampionBuilder.resetAndUpdate(champion);
                }
                ArrayList<IAffix> affixes = new ArrayList<IAffix>();
                MinMaxBounds.Ints tierRange = gatewaysSetting.tierRange();
                int minTier = tierRange.min().orElse(0);
                int maxTier = tierRange.max().orElse(RankManager.getHighestRank().getTier());
                int rangedRandomTier = champion.getLivingEntity().getRandom().nextIntBetweenInclusive(minTier, maxTier);
                gatewaysSetting.affixes().forEach(affixId -> affixes.add((IAffix)AffixRegistry.AFFIX_REGISTRY.get(affixId)));
                ChampionBuilder.spawnPreset(champion, rangedRandomTier, affixes);
            });
        });
    }
}

