/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.event;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.integration.theoneprobe.TheOneProbePlugin;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.datagen.AffixConfigProvider;
import top.theillusivec4.champions.common.datagen.AttributesModifierDataProvider;
import top.theillusivec4.champions.common.datagen.GatewaysConfigProvider;
import top.theillusivec4.champions.common.datagen.ModAdvancementProvider;
import top.theillusivec4.champions.common.datagen.ModDamageTypeTagsProvider;
import top.theillusivec4.champions.common.datagen.ModDatapackProvider;
import top.theillusivec4.champions.common.datagen.ModEntityTypeTagsProvider;
import top.theillusivec4.champions.common.datagen.ModGlobalLootModifierProvider;
import top.theillusivec4.champions.common.datagen.ModLanguageProvider;
import top.theillusivec4.champions.common.item.dispense.DispenseHandler;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;
import top.theillusivec4.champions.common.network.SPacketSyncChampion;
import top.theillusivec4.champions.common.network.SyncAffixSettingPacket;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.registry.ModStats;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.common.util.Utils;
import top.theillusivec4.champions.server.command.ChampionSelectorOptions;

public class ModEventHandler {
    @SubscribeEvent
    private void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("champions");
        registrar.playToClient(SPacketSyncAffixData.TYPE, SPacketSyncAffixData.STREAM_CODEC, SPacketSyncAffixData::handle);
        registrar.playToClient(SPacketSyncChampion.TYPE, SPacketSyncChampion.STREAM_CODEC, SPacketSyncChampion::handle);
        registrar.playToClient(SyncAffixSettingPacket.TYPE, SyncAffixSettingPacket.STREAM_CODEC, SyncAffixSettingPacket::handle);
    }

    @SubscribeEvent
    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Utils.createServerConfig(ChampionsConfig.RANKS_SPEC, "ranks");
            Utils.createServerConfig(ChampionsConfig.ENTITIES_SPEC, "entities");
            ChampionAttachment.register();
            ModStats.registerFormatter();
            ChampionSelectorOptions.setup();
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.CHAMPION_EGG_ITEM.get()), DispenseHandler::handleChampionEggDispense);
        });
    }

    @SubscribeEvent
    private void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            Champions.LOGGER.info("Champions detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)"champions", (String)"theoneprobe", (String)"getTheOneProbe", TheOneProbePlugin.GetTheOneProbe::new);
        }
    }

    @SubscribeEvent
    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModDatapackProvider datapackProvider = (ModDatapackProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new GatewaysConfigProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new ModAdvancementProvider.Generator())));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(packOutput, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AffixConfigProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new AttributesModifierDataProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "zh_cn"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "ko_kr"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "ru_ru"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "tr_tr"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "uk_ua"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "pt_br"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    private void config(ModConfigEvent.Loading evt) {
        if (!evt.getConfig().getModId().equals("champions")) {
            return;
        }
        if (evt.getConfig().getType() == ModConfig.Type.SERVER) {
            ChampionsConfig.bake();
            ModEventHandler modEventHandler = this;
            synchronized (modEventHandler) {
                IConfigSpec spec = evt.getConfig().getSpec();
                CommentedConfig commentedConfig = evt.getConfig().getLoadedConfig().config();
                try {
                    if (spec == ChampionsConfig.RANKS_SPEC) {
                        ChampionsConfig.transformRanks(commentedConfig);
                        RankManager.buildRanks();
                    } else if (spec == ChampionsConfig.ENTITIES_SPEC) {
                        ChampionsConfig.transformEntities(commentedConfig);
                        EntityManager.buildEntitySettings();
                    } else if (spec == ChampionsConfig.STAGE_SPEC && Utils.isGameStagesLoaded()) {
                        ChampionsConfig.entityStages = (List)ChampionsConfig.STAGE.entityStages.get();
                        ChampionsConfig.tierStages = (List)ChampionsConfig.STAGE.tierStages.get();
                    }
                }
                catch (Exception e) {
                    Champions.LOGGER.error("Error loading config, please remove this file or check the format is correct: {}", (Object)FMLPaths.GAMEDIR.get().resolve(evt.getConfig().getFullPath()), (Object)e);
                }
            }
        }
        if (evt.getConfig().getType() == ModConfig.Type.CLIENT) {
            ClientChampionsConfig.bake();
        } else if (evt.getConfig().getType() == ModConfig.Type.COMMON) {
            ChampionsConfig.bakeCommon();
        }
    }

    @SubscribeEvent
    private void onClientSetup(FMLClientSetupEvent event) {
        Champions.getInstance().modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    private void registerRegistries(NewRegistryEvent event) {
        event.register(AffixRegistry.AFFIX_REGISTRY);
    }
}

