/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobSplitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.event.customEvent.ChampionsEventHooks;
import top.theillusivec4.champions.common.network.SyncAffixSettingPacket;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.AffixTypes;
import top.theillusivec4.champions.common.registry.ModParticleTypes;
import top.theillusivec4.champions.common.registry.ModStats;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.Utils;
import top.theillusivec4.champions.server.command.ChampionsCommand;

public class ChampionEventsHandler {
    @SubscribeEvent
    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)Champions.API.getAffixDataLoader());
        event.addListener((PreparableReloadListener)Champions.API.getAttributesModifierDataLoader());
    }

    @SubscribeEvent
    private void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        ChampionAttachment.getAttachment((Entity)livingEntity).flatMap(champion -> champion.getServer().getRank()).ifPresent(rank -> {
            int growth = rank.getGrowthFactor();
            if (growth > 0) {
                evt.setDroppedExperience(growth * ChampionsConfig.experienceGrowth * evt.getOriginalExperience() + evt.getDroppedExperience());
            }
        });
    }

    @SubscribeEvent
    private void onExplosion(ExplosionEvent.Start evt) {
        Explosion explosion = evt.getExplosion();
        Entity entity = explosion.getDirectSourceEntity();
        if (entity != null && !entity.level().isClientSide()) {
            ChampionAttachment.getAttachment(entity).flatMap(champion -> champion.getServer().getRank()).ifPresent(rank -> {
                int growth = rank.getGrowthFactor();
                if (growth > 0) {
                    explosion.radius += (float)(ChampionsConfig.explosionGrowth * growth);
                }
            });
        }
    }

    @SubscribeEvent
    private void onMobSpilt(MobSplitEvent event) {
        if (ChampionsConfig.mobInherit) {
            Mob parentMob = event.getParent();
            List children = event.getChildren();
            ChampionAttachment.getAttachment((Entity)parentMob).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    serverChampion.getRank().ifPresent(rank -> children.forEach(child -> ChampionAttachment.getAttachment((Entity)child).ifPresent(championChild -> {
                        ArrayList<IAffix> parentAffixes = new ArrayList<IAffix>(serverChampion.getAffixes());
                        if (!ChampionsConfig.canHaveInfestedAffix) {
                            parentAffixes.remove(AffixTypes.INFESTED.get());
                        }
                        championChild.getServer().setRank(RankManager.getRank(rank.getTier() - ChampionsConfig.rankReduce));
                        if (!parentAffixes.isEmpty()) {
                            championChild.getServer().setAffixes(parentAffixes);
                        }
                        ChampionBuilder.applyGrowth(championChild, championChild.getServer().getRank().orElse(RankManager.getEmptyRank()).getGrowthFactor());
                    })));
                }
            });
        }
    }

    @SubscribeEvent
    private void onLivingJoinWorld(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.level().isClientSide() && ChampionHelper.isValidChampionEntity(entity)) {
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Optional<Rank> maybeRank = serverChampion.getRank();
                if (maybeRank.isEmpty()) {
                    if (!ChampionsEventHooks.onAttemptChampionSpawn(champion)) {
                        evt.setCanceled(true);
                        return;
                    }
                    ChampionBuilder.spawn(champion);
                }
                Utils.consumeIfLifeCycle(serverChampion.getAffixes(), lifecycle -> lifecycle.onSpawn((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                    effects.forEach(effectPair -> champion.getLivingEntity().addEffect(new MobEffectInstance((Holder)effectPair.getA(), 200, ((Integer)effectPair.getB()).intValue())));
                });
            });
        }
    }

    @SubscribeEvent
    private void onLivingUpdate(EntityTickEvent.Pre evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.level().isClientSide()) {
                ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    if (ChampionHelper.isValidChampion(clientChampion)) {
                        Utils.consumeIfLifeCycle(clientChampion.getAffixes(), lifecycle -> lifecycle.onClientUpdate((IChampion)champion));
                        clientChampion.getRank().ifPresent(rank -> {
                            if (ChampionsConfig.showParticles && (Integer)rank.getA() >= 1) {
                                String colorCode = (String)rank.getB();
                                int color = Rank.getColor(colorCode);
                                float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                                float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                                float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                                livingEntity.level().addParticle((ParticleOptions)ModParticleTypes.RANK_PARTICLE_TYPE.get(), livingEntity.position().x + (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth(), livingEntity.position().y + livingEntity.getRandom().nextDouble() * (double)livingEntity.getBbHeight(), livingEntity.position().z + (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth(), (double)r, (double)g, (double)b);
                            }
                        });
                    }
                });
            } else if (livingEntity.tickCount % 10 == 0) {
                ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                    IChampion.Server serverChampion = champion.getServer();
                    if (ChampionHelper.isValidChampion(serverChampion)) {
                        Utils.consumeIfLifeCycle(serverChampion.getAffixes(), lifecycle -> lifecycle.onServerUpdate((IChampion)champion));
                        serverChampion.getRank().ifPresent(rank -> {
                            if (livingEntity.tickCount % 4 == 0) {
                                List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                                effects.forEach(effectPair -> livingEntity.addEffect(new MobEffectInstance((Holder)effectPair.getA(), 100, ((Integer)effectPair.getB()).intValue())));
                            }
                        });
                    }
                });
            }
        }
    }

    @SubscribeEvent
    private void onPlayerRightClick(PlayerInteractEvent.EntityInteract event) {
        if (ChampionsConfig.enableDebug) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            if (!target.level().isClientSide() && ChampionHelper.isChampionEntity(target)) {
                ChampionAttachment.getAttachment(target).ifPresent(ChampionBuilder::resetAndUpdate);
                player.sendSystemMessage((Component)Component.literal((String)"[Debug] Removed %s rank, affixes and attribute modifiers".formatted(target.getName().getString())));
            }
        }
    }

    @SubscribeEvent
    private void onLivingAttack(LivingIncomingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                        if (!combatAffix.onAttacked((IChampion)champion, evt.getSource(), evt.getAmount())) {
                            evt.setCanceled(true);
                        }
                    });
                }
            });
            if (evt.isCanceled()) {
                return;
            }
            Entity source = evt.getSource().getDirectEntity();
            ChampionAttachment.getAttachment(source).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                        if (!combatAffix.onAttack((IChampion)champion, evt.getEntity(), evt.getSource(), evt.getAmount())) {
                            evt.setCanceled(true);
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent
    private void onLivingDamage(LivingDamageEvent.Pre evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            float[] amounts = new float[]{evt.getOriginalDamage(), evt.getNewDamage()};
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                        amounts[1] = combatAffix.onDamage((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                    });
                    Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                        amounts[1] = combatAffix.onHurt((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                    });
                    evt.setNewDamage(amounts[1]);
                }
            });
        }
    }

    @SubscribeEvent
    private void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity.level().isClientSide()) {
            return;
        }
        ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            if (ChampionHelper.isValidChampion(serverChampion)) {
                Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                    if (!combatAffix.onDeath((IChampion)champion, evt.getSource())) {
                        evt.setCanceled(true);
                    }
                });
                serverChampion.getRank().ifPresent(rank -> {
                    Entity source;
                    if (!evt.isCanceled() && (source = evt.getSource().getEntity()) instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)source;
                        if (!(source instanceof FakePlayer)) {
                            MinecraftServer server;
                            player.awardStat((ResourceLocation)ModStats.CHAMPION_MOBS_KILLED.get());
                            int messageTier = ChampionsConfig.deathMessageTier;
                            if (messageTier > 0 && rank.getTier() >= messageTier && (server = livingEntity.getServer()) != null) {
                                server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)("rank.champions.title." + rank.getTier())).append(" ").append(livingEntity.getCombatTracker().getDeathMessage()), false);
                            }
                        }
                    }
                });
            }
        });
    }

    @SubscribeEvent
    private void onServerStart(ServerAboutToStartEvent evt) {
        ChampionHelper.setServer(evt.getServer());
    }

    @SubscribeEvent
    private void onServerClose(ServerStoppedEvent evt) {
        ChampionHelper.setServer(null);
        ChampionHelper.clearBeacons();
    }

    @SubscribeEvent
    private void onLivingHeal(LivingHealEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    Utils.consumeIfCombat(serverChampion.getAffixes(), combatAffix -> {
                        amounts[1] = combatAffix.onHeal((IChampion)champion, amounts[0], amounts[1]);
                    });
                }
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    private void onBossBarEvent(CustomizeGuiOverlayEvent.BossEventProgress event) {
        event.setCanceled(ChampionsOverlay.isRendering);
    }

    @SubscribeEvent
    private void onDatapackSync(OnDatapackSyncEvent event) {
        Stream relevantPlayers = event.getRelevantPlayers();
        SyncAffixSettingPacket syncAffixSetting = new SyncAffixSettingPacket(Champions.API.getAffixDataLoader().getLoadedData());
        SyncAffixSettingPacket.handelSettingMainThread();
        relevantPlayers.forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)syncAffixSetting, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @SubscribeEvent
    private void registerCommands(RegisterCommandsEvent evt) {
        ChampionsCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }
}

