/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class ModEntityTypeTagsProvider
extends TagsProvider<EntityType<?>> {
    public ModEntityTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper helper) {
        super(output, Registries.ENTITY_TYPE, future, "champions", helper);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.tag(ModEntityTypes.Tags.IS_ENDER).add(this.lookup(provider, "ender_dragon"));
        this.tag(ModEntityTypes.Tags.IS_ENDER).add(this.lookup(provider, "endermite"));
        this.tag(ModEntityTypes.Tags.IS_ENDER).add(this.lookup(provider, "enderman"));
        this.tag(ModEntityTypes.Tags.IS_ENDER).add(this.lookup(provider, "shulker"));
        this.lookUpMonster(provider).listElements().forEach(this::addEntity);
    }

    void addEntity(Holder.Reference<EntityType<?>> entityType) {
        this.tag(ModEntityTypes.Tags.ALLOW_CHAMPIONS).add(entityType.key());
    }

    private HolderLookup.RegistryLookup<EntityType<?>> lookUpMonster(@NotNull HolderLookup.Provider provider) {
        return provider.lookupOrThrow(Registries.ENTITY_TYPE).filterElements(entityType -> entityType.getCategory() == MobCategory.MONSTER);
    }

    private ResourceKey<EntityType<?>> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)name));
    }

    private ResourceKey<EntityType<?>> lookup(HolderLookup.Provider provider, String name) {
        return provider.lookupOrThrow(Registries.ENTITY_TYPE).getOrThrow(this.create(name)).key();
    }
}

