/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import top.theillusivec4.champions.common.affix.DampeningAffix;
import top.theillusivec4.champions.common.affix.DesecratingAffix;
import top.theillusivec4.champions.common.affix.HastyAffix;
import top.theillusivec4.champions.common.affix.MagneticAffix;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.Gateways;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysSetting;
import top.theillusivec4.champions.common.registry.AffixTypes;
import top.theillusivec4.champions.common.util.Utils;

public class GatewaysConfigProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final List<GatewaysSetting> gatewaysSettings = new ArrayList<GatewaysSetting>();

    public GatewaysConfigProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList futures = new ArrayList();
        this.gatewaysSettings.add(new GatewaysSetting(Utils.getLocation("wave_0to1"), MinMaxBounds.Ints.atLeast((int)1), List.of(((HastyAffix)AffixTypes.HASTY.get()).getIdentifier()), MinMaxBounds.Ints.between((int)0, (int)1), Gateways.NORMAL, Optional.of(List.of(ResourceLocation.withDefaultNamespace((String)"pig"), ResourceLocation.withDefaultNamespace((String)"zombie"))), Optional.of(false)));
        this.gatewaysSettings.add(new GatewaysSetting(Utils.getLocation("wave_2to5"), MinMaxBounds.Ints.atLeast((int)2), List.of(((MagneticAffix)AffixTypes.MAGNETIC.get()).getIdentifier(), ((DampeningAffix)AffixTypes.DAMPENING.get()).getIdentifier(), ((DesecratingAffix)AffixTypes.DESECRATING.get()).getIdentifier()), MinMaxBounds.Ints.between((int)2, (int)5), Gateways.NORMAL, Optional.of(List.of(ResourceLocation.withDefaultNamespace((String)"pig"), ResourceLocation.withDefaultNamespace((String)"zombie"))), Optional.of(false)));
        this.gatewaysSettings.forEach(affix -> {
            Path outputPath = this.packOutput.getOutputFolder().resolve("data/" + affix.id().getNamespace() + "/gateway_setting/" + affix.id().getPath() + ".json");
            futures.add(this.lookupProvider.thenCompose(provider -> DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)((JsonElement)GatewaysSetting.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, affix).getOrThrow()), (Path)outputPath)));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Gateways_setting";
    }
}

