/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import top.theillusivec4.champions.api.data.AttributesModifierDataLoader;
import top.theillusivec4.champions.api.data.ChampionModifierCondition;
import top.theillusivec4.champions.api.data.ModifierSetting;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.loot.AffixesPredicate;

public class AttributesModifierDataProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public AttributesModifierDataProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList futures = new ArrayList();
        BuiltInRegistries.ATTRIBUTE.asLookup().listElements().forEach(attribute -> {
            ResourceLocation attributeId = attribute.key().location();
            var ref = new Object(this){
                double baseValue = 1.0;
                boolean enable = false;
                AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_VALUE;
            };
            Path outputPath = this.packOutput.getOutputFolder().resolve("data").resolve(attributeId.getNamespace()).resolve(AttributesModifierDataLoader.getFolder()).resolve(attributeId.getPath() + ".json");
            if (attribute == Attributes.MAX_HEALTH) {
                ref.baseValue = 0.35;
                ref.enable = true;
                ref.operation = AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            } else if (attribute == Attributes.ATTACK_DAMAGE) {
                ref.baseValue = 0.5;
                ref.enable = true;
                ref.operation = AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            } else if (attribute == Attributes.ARMOR) {
                ref.baseValue = 2.0;
                ref.enable = true;
            } else if (attribute == Attributes.ARMOR_TOUGHNESS) {
                ref.baseValue = 1.0;
                ref.enable = true;
            } else if (attribute == Attributes.KNOCKBACK_RESISTANCE) {
                ref.baseValue = 0.05;
                ref.enable = true;
            } else {
                ref.baseValue = 0.0;
                ref.enable = false;
                ref.operation = AttributeModifier.Operation.ADD_VALUE;
            }
            futures.add(this.lookupProvider.thenCompose(provider -> DataProvider.saveStable((CachedOutput)cachedOutput, (HolderLookup.Provider)provider, (Codec)ModifierSetting.MAP_CODEC.codec(), (Object)new ModifierSetting(attributeId, ref.enable, (Pair<Double, AttributeModifier.Operation>)Pair.of((Object)ref.baseValue, (Object)ref.operation), Optional.of(new ChampionModifierCondition(Optional.of(Set.of(ResourceLocation.parse((String)"minecraft:creeper"))), Optional.of(MinMaxBounds.Ints.ANY), Optional.of(new AffixesPredicate(Set.of(), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY)), ConfigEnums.Permission.BLACKLIST))), (Path)outputPath)));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "attribute modifiers";
    }
}

