/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.data.AffixDataLoader;
import top.theillusivec4.champions.api.data.AffixSetting;

public class AffixConfigProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public AffixConfigProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        ArrayList futures = new ArrayList();
        Champions.API.getAffixes().forEach(affix -> {
            ResourceLocation affixId = affix.getIdentifier();
            Path outputPath = this.packOutput.getOutputFolder().resolve("data").resolve(affixId.getNamespace()).resolve(AffixDataLoader.getFolder()).resolve(affixId.getPath() + ".json");
            futures.add(this.lookupProvider.thenCompose(provider -> DataProvider.saveStable((CachedOutput)cachedOutput, (HolderLookup.Provider)provider, AffixSetting.CODEC, (Object)affix.getSetting(), (Path)outputPath)));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Affix_configs";
    }
}

